/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.placeable;

import com.tterrag.registrate.util.entry.ItemEntry;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;
import net.tropicraft.core.common.item.AshenMasks;
import net.tropicraft.core.common.item.TropicraftItems;

public class AshenMaskEntity
extends Entity {
    private static final EntityDataAccessor<Byte> MASK_TYPE = SynchedEntityData.defineId(AshenMaskEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    public static final int MAX_TICKS_ALIVE = 24000;

    public AshenMaskEntity(EntityType<?> type, Level world) {
        super(type, world);
    }

    public void dropItemStack(ServerLevel level) {
        ItemEntry mask = (ItemEntry)TropicraftItems.ASHEN_MASKS.get((Object)AshenMasks.VALUES[this.getMaskType()]);
        this.spawnAtLocation(level, new ItemStack((ItemLike)mask.get()), 1.0f);
    }

    public boolean isPickable() {
        return true;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(MASK_TYPE, (Object)0);
    }

    protected void readAdditionalSaveData(ValueInput input) {
        this.setMaskType(input.getByteOr("MaskType", (byte)0));
    }

    protected void addAdditionalSaveData(ValueOutput output) {
        output.putByte("MaskType", this.getMaskType());
    }

    public void setMaskType(byte type) {
        this.entityData.set(MASK_TYPE, (Object)type);
    }

    public byte getMaskType() {
        return (Byte)this.entityData.get(MASK_TYPE);
    }

    public void tick() {
        if (!this.level().isClientSide && this.tickCount >= 24000) {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
        Vec3 motion = this.getDeltaMovement();
        if (this.onGround()) {
            this.setDeltaMovement(motion.multiply(0.5, 0.0, 0.5));
        }
        if (this.isInWater()) {
            this.setDeltaMovement(motion.x * (double)0.95f, 0.02f, motion.z * (double)0.95f);
        } else {
            this.setDeltaMovement(motion.subtract(0.0, (double)0.05f, 0.0));
        }
        this.move(MoverType.SELF, motion);
    }

    public boolean hurtServer(ServerLevel level, DamageSource damageSource, float amount) {
        if (this.isInvulnerableToBase(damageSource)) {
            return false;
        }
        if (this.isAlive()) {
            this.remove(Entity.RemovalReason.KILLED);
            this.markHurt();
            this.dropItemStack(level);
        }
        return true;
    }

    public ItemStack getPickResult() {
        return new ItemStack((ItemLike)((ItemEntry)TropicraftItems.ASHEN_MASKS.get((Object)AshenMasks.VALUES[this.getMaskType()])).get());
    }
}

