/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.underdasea;

import javax.annotation.Nullable;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public abstract class AbstractTexturedFishEntity
extends AbstractFish {
    private static final EntityDataAccessor<String> TEXTURE_NAME = SynchedEntityData.defineId(AbstractTexturedFishEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);

    public AbstractTexturedFishEntity(EntityType<? extends AbstractFish> type, Level world) {
        super(type, world);
    }

    abstract String getRandomTexture();

    abstract String getDefaultTexture();

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(TEXTURE_NAME, (Object)this.getDefaultTexture());
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficultyInstance, EntitySpawnReason spawnReason, @Nullable SpawnGroupData entityData) {
        this.setTexture(this.getRandomTexture());
        return super.finalizeSpawn(world, difficultyInstance, spawnReason, entityData);
    }

    public void addAdditionalSaveData(ValueOutput output) {
        super.addAdditionalSaveData(output);
        output.putString("Texture", this.getTexture());
    }

    public void readAdditionalSaveData(ValueInput input) {
        super.readAdditionalSaveData(input);
        this.setTexture(input.getStringOr("Texture", this.getDefaultTexture()));
    }

    public void setTexture(String textureName) {
        this.getEntityData().set(TEXTURE_NAME, (Object)textureName);
    }

    public String getTexture() {
        return (String)this.getEntityData().get(TEXTURE_NAME);
    }
}

