/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.underdasea;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.tropicraft.core.common.entity.TropicraftEntities;

public class ManOWarEntity
extends WaterAnimal {
    public float squidPitch;
    public float prevSquidPitch;
    public float squidYaw;
    public float prevSquidYaw;
    public float squidRotation;
    public float prevSquidRotation;
    public float tentacleAngle;
    public float lastTentacleAngle;
    private float randomMotionSpeed;
    private float rotationVelocity;
    private float rotateSpeed;
    private float randomMotionVecX;
    private float randomMotionVecY;
    private float randomMotionVecZ;
    private int attackTimer = 0;

    public ManOWarEntity(EntityType<? extends ManOWarEntity> type, Level world) {
        super(type, world);
        this.random.setSeed((long)this.getId());
        this.rotationVelocity = 1.0f / (this.random.nextFloat() + 1.0f) * 0.2f;
        this.xpReward = 7;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new MoveRandomGoal(this));
        this.goalSelector.addGoal(1, (Goal)new FleeGoal());
    }

    public static AttributeSupplier.Builder createAttributes() {
        return WaterAnimal.createMobAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.ATTACK_DAMAGE, 3.0);
    }

    protected float getSoundVolume() {
        return 0.4f;
    }

    public LivingEntity getTarget() {
        return null;
    }

    public void aiStep() {
        super.aiStep();
        this.prevSquidPitch = this.squidPitch;
        this.prevSquidYaw = this.squidYaw;
        this.prevSquidRotation = this.squidRotation;
        this.lastTentacleAngle = this.tentacleAngle;
        this.squidRotation += this.rotationVelocity;
        if ((double)this.squidRotation > 6.2831854820251465) {
            if (this.level().isClientSide) {
                this.squidRotation = (float)Math.PI * 2;
            } else {
                this.squidRotation = (float)((double)this.squidRotation - 6.2831854820251465);
                if (this.random.nextInt(10) == 0) {
                    this.rotationVelocity = 1.0f / (this.random.nextFloat() + 1.0f) * 0.2f;
                }
                this.level().broadcastEntityEvent((Entity)this, (byte)19);
            }
        }
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
        if (this.isInWater()) {
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (this.random.nextInt(5) == 0 && this.attackTimer <= 0) {
                    List list = serverLevel.getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(2.0, 4.0, 2.0).move(0.0, -2.0, 0.0), EntitySelector.NO_CREATIVE_OR_SPECTATOR);
                    for (LivingEntity ent : list) {
                        if (ent.getType() == TropicraftEntities.MAN_O_WAR.get() || !ent.isInWater()) continue;
                        ent.hurtServer(serverLevel, this.damageSources().mobAttack((LivingEntity)this), (float)this.getAttributeValue(Attributes.ATTACK_DAMAGE));
                        this.attackTimer = 20;
                    }
                }
            }
            if (this.squidRotation < (float)Math.PI) {
                float lvt_1_1_ = this.squidRotation / (float)Math.PI;
                this.tentacleAngle = Mth.sin((float)(lvt_1_1_ * lvt_1_1_ * (float)Math.PI)) * (float)Math.PI * 0.25f;
                if ((double)lvt_1_1_ > 0.75) {
                    this.randomMotionSpeed = 1.0f;
                    this.rotateSpeed = 1.0f;
                } else {
                    this.rotateSpeed *= 0.8f;
                }
            } else {
                this.tentacleAngle = 0.0f;
                this.randomMotionSpeed *= 0.9f;
                this.rotateSpeed *= 0.99f;
            }
            if (!this.level().isClientSide) {
                this.setDeltaMovement(this.randomMotionVecX * this.randomMotionSpeed, this.randomMotionVecY * this.randomMotionSpeed, this.randomMotionVecZ * this.randomMotionSpeed);
            }
            Vec3 motion = this.getDeltaMovement();
            double horizontalDistance = motion.horizontalDistance();
            this.yBodyRot += (-((float)Mth.atan2((double)motion.x, (double)motion.z)) * 57.295776f - this.yBodyRot) * 0.1f;
            this.setYRot(this.yBodyRot);
            this.squidYaw = (float)((double)this.squidYaw + Math.PI * (double)this.rotateSpeed * 1.5);
            this.squidPitch += (-((float)Mth.atan2((double)horizontalDistance, (double)motion.y)) * 57.295776f - this.squidPitch) * 0.1f;
        } else {
            this.tentacleAngle = Mth.abs((float)Mth.sin((float)this.squidRotation)) * (float)Math.PI * 0.25f;
            if (!this.level().isClientSide) {
                double lvt_1_3_ = this.getDeltaMovement().y;
                if (this.hasEffect(MobEffects.LEVITATION)) {
                    lvt_1_3_ = 0.05 * (double)(this.getEffect(MobEffects.LEVITATION).getAmplifier() + 1);
                } else if (!this.isNoGravity()) {
                    lvt_1_3_ -= 0.08;
                }
                this.setDeltaMovement(0.0, lvt_1_3_ * (double)0.98f, 0.0);
            }
            this.squidPitch = (float)((double)this.squidPitch + (double)(-90.0f - this.squidPitch) * 0.02);
        }
    }

    public void die(DamageSource d) {
        super.die(d);
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            int numDrops = 3 + this.random.nextInt(1);
            for (int i = 0; i < numDrops; ++i) {
                this.spawnAtLocation(serverLevel, (ItemLike)Items.SLIME_BALL, 1);
            }
        }
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.SQUID_AMBIENT;
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return SoundEvents.SQUID_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.SQUID_DEATH;
    }

    public void travel(Vec3 vector) {
        this.move(MoverType.SELF, this.getDeltaMovement());
    }

    public void handleEntityEvent(byte id) {
        if (id == 19) {
            this.squidRotation = 0.0f;
        } else {
            super.handleEntityEvent(id);
        }
    }

    public void setMovementVector(float randomMotionVecXIn, float randomMotionVecYIn, float randomMotionVecZIn) {
        this.randomMotionVecX = randomMotionVecXIn;
        this.randomMotionVecY = randomMotionVecYIn;
        this.randomMotionVecZ = randomMotionVecZIn;
    }

    public boolean hasMovementVector() {
        return this.randomMotionVecX != 0.0f || this.randomMotionVecY != 0.0f || this.randomMotionVecZ != 0.0f;
    }

    static class MoveRandomGoal
    extends Goal {
        private final ManOWarEntity manOWarEntity;

        public MoveRandomGoal(ManOWarEntity p_i48823_2_) {
            this.manOWarEntity = p_i48823_2_;
        }

        public boolean canUse() {
            return true;
        }

        public void tick() {
            int lvt_1_1_ = this.manOWarEntity.getNoActionTime();
            if (lvt_1_1_ > 100) {
                this.manOWarEntity.setMovementVector(0.0f, 0.0f, 0.0f);
            } else if (this.manOWarEntity.getRandom().nextInt(50) == 0 || !this.manOWarEntity.isInWater() || !this.manOWarEntity.hasMovementVector()) {
                float lvt_2_1_ = this.manOWarEntity.getRandom().nextFloat() * ((float)Math.PI * 2);
                float lvt_3_1_ = Mth.cos((float)lvt_2_1_) * 0.2f;
                float lvt_4_1_ = -0.1f + this.manOWarEntity.getRandom().nextFloat() * 0.2f;
                float lvt_5_1_ = Mth.sin((float)lvt_2_1_) * 0.2f;
                this.manOWarEntity.setMovementVector(lvt_3_1_, lvt_4_1_, lvt_5_1_);
            }
        }
    }

    class FleeGoal
    extends Goal {
        private int tickCounter;

        private FleeGoal() {
        }

        public boolean canUse() {
            LivingEntity lvt_1_1_ = ManOWarEntity.this.getLastHurtByMob();
            if (ManOWarEntity.this.isInWater() && lvt_1_1_ != null) {
                return ManOWarEntity.this.distanceToSqr((Entity)lvt_1_1_) < 100.0;
            }
            return false;
        }

        public void start() {
            this.tickCounter = 0;
        }

        public void tick() {
            ++this.tickCounter;
            LivingEntity target = ManOWarEntity.this.getLastHurtByMob();
            if (target != null) {
                Vec3 lvt_2_1_ = new Vec3(ManOWarEntity.this.getX() - target.getX(), ManOWarEntity.this.getY() - target.getY(), ManOWarEntity.this.getZ() - target.getZ());
                BlockState block = ManOWarEntity.this.level().getBlockState(BlockPos.containing((double)(ManOWarEntity.this.getX() + lvt_2_1_.x), (double)(ManOWarEntity.this.getY() + lvt_2_1_.y), (double)(ManOWarEntity.this.getZ() + lvt_2_1_.z)));
                FluidState fluid = ManOWarEntity.this.level().getFluidState(BlockPos.containing((double)(ManOWarEntity.this.getX() + lvt_2_1_.x), (double)(ManOWarEntity.this.getY() + lvt_2_1_.y), (double)(ManOWarEntity.this.getZ() + lvt_2_1_.z)));
                if (fluid.is(FluidTags.WATER) || block.isAir()) {
                    double lvt_5_1_ = lvt_2_1_.length();
                    if (lvt_5_1_ > 0.0) {
                        lvt_2_1_.normalize();
                        float lvt_7_1_ = 3.0f;
                        if (lvt_5_1_ > 5.0) {
                            lvt_7_1_ = (float)((double)lvt_7_1_ - (lvt_5_1_ - 5.0) / 5.0);
                        }
                        if (lvt_7_1_ > 0.0f) {
                            lvt_2_1_ = lvt_2_1_.scale((double)lvt_7_1_);
                        }
                    }
                    if (block.isAir()) {
                        lvt_2_1_ = lvt_2_1_.subtract(0.0, lvt_2_1_.y, 0.0);
                    }
                    ManOWarEntity.this.setMovementVector((float)lvt_2_1_.x / 20.0f, (float)lvt_2_1_.y / 20.0f, (float)lvt_2_1_.z / 20.0f);
                }
                if (this.tickCounter % 10 == 5) {
                    ManOWarEntity.this.level().addParticle((ParticleOptions)ParticleTypes.BUBBLE, ManOWarEntity.this.getX(), ManOWarEntity.this.getY(), ManOWarEntity.this.getZ(), 0.0, 0.0, 0.0);
                }
            }
        }
    }
}

