/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.underdasea;

import javax.annotation.Nullable;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class MarlinEntity
extends AbstractFish {
    private static final String DEFAULT_TEXTURE = "marlin";
    private static final EntityDataAccessor<String> TEXTURE_NAME = SynchedEntityData.defineId(MarlinEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);

    public MarlinEntity(EntityType<? extends AbstractFish> type, Level world) {
        super(type, world);
        this.xpReward = 5;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(TEXTURE_NAME, (Object)DEFAULT_TEXTURE);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return AbstractFish.createAttributes().add(Attributes.MAX_HEALTH, 5.0);
    }

    protected InteractionResult mobInteract(Player player, InteractionHand hand) {
        return InteractionResult.PASS;
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficultyInstance, EntitySpawnReason spawnReason, @Nullable SpawnGroupData entityData) {
        this.setTexture(this.random.nextInt(50) == 0 ? "purple_marlin" : DEFAULT_TEXTURE);
        return super.finalizeSpawn(world, difficultyInstance, spawnReason, entityData);
    }

    public void addAdditionalSaveData(ValueOutput output) {
        super.addAdditionalSaveData(output);
        output.putString("Texture", this.getTexture());
    }

    public void readAdditionalSaveData(ValueInput input) {
        super.readAdditionalSaveData(input);
        this.setTexture(input.getStringOr("Texture", DEFAULT_TEXTURE));
    }

    public ItemStack getBucketItemStack() {
        return ItemStack.EMPTY;
    }

    protected SoundEvent getFlopSound() {
        return SoundEvents.SALMON_FLOP;
    }

    public void setTexture(String textureName) {
        this.getEntityData().set(TEXTURE_NAME, (Object)textureName);
    }

    public String getTexture() {
        return (String)this.getEntityData().get(TEXTURE_NAME);
    }
}

