/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.underdasea;

import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.AbstractSchoolingFish;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.PathType;
import net.tropicraft.core.common.entity.underdasea.IAtlasFish;

public class PiranhaEntity
extends AbstractSchoolingFish
implements IAtlasFish {
    public PiranhaEntity(EntityType<? extends AbstractSchoolingFish> type, Level world) {
        super(type, world);
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.moveControl = new SmoothSwimmingMoveControl((Mob)this, 85, 20, 0.2f, 0.5f, false);
        this.lookControl = new SmoothSwimmingLookControl((Mob)this, 10);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return AbstractFish.createAttributes().add(Attributes.MAX_HEALTH, 5.0).add(Attributes.FOLLOW_RANGE, 12.0).add(Attributes.MOVEMENT_SPEED, 0.8).add(Attributes.ATTACK_DAMAGE, 2.0);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 12.0f));
        this.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, (double)1.3f, true));
        this.goalSelector.addGoal(4, (Goal)new FishRandomSwimGoal((AbstractFish)this));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public int getHeadRotSpeed() {
        return 30;
    }

    protected InteractionResult mobInteract(Player player, InteractionHand hand) {
        return InteractionResult.PASS;
    }

    public int getMaxSchoolSize() {
        return 20;
    }

    public ItemStack getBucketItemStack() {
        return ItemStack.EMPTY;
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.SALMON_AMBIENT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.SALMON_DEATH;
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return SoundEvents.SALMON_HURT;
    }

    protected SoundEvent getFlopSound() {
        return SoundEvents.SALMON_FLOP;
    }

    @Override
    public int getAtlasSlot() {
        return 9;
    }

    static class FishRandomSwimGoal
    extends RandomSwimmingGoal {
        private final AbstractFish fish;

        public FishRandomSwimGoal(AbstractFish fish) {
            super((PathfinderMob)fish, 1.0, 40);
            this.fish = fish;
        }

        public boolean canUse() {
            return this.fish.getTarget() != null && super.canUse();
        }
    }
}

