/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.underdasea;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.tropicraft.core.common.entity.TropicraftEntities;
import net.tropicraft.core.common.entity.egg.EggEntity;
import net.tropicraft.core.common.entity.egg.SeaUrchinEggEntity;
import net.tropicraft.core.common.entity.underdasea.EchinodermEntity;

public class SeaUrchinEntity
extends EchinodermEntity {
    public static final float BABY_SIZE = 0.25f;
    public static final float ADULT_SIZE = 0.5f;
    public static final float BABY_YOFFSET = 0.125f;
    public static final float ADULT_YOFFSET = 0.25f;

    public SeaUrchinEntity(EntityType<? extends EchinodermEntity> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return WaterAnimal.createMobAttributes().add(Attributes.MAX_HEALTH, 10.0);
    }

    public boolean hurtServer(ServerLevel level, DamageSource source, float amt) {
        Player player;
        Entity entity;
        if (source.is(DamageTypes.PLAYER_ATTACK) && (entity = source.getEntity()) instanceof Player && (player = (Player)entity).getMainHandItem().isEmpty()) {
            player.hurtServer(level, this.damageSources().mobAttack((LivingEntity)this), 2.0f);
        }
        return super.hurtServer(level, source, amt);
    }

    public void push(Entity ent) {
        super.push(ent);
        if (!this.level().isClientSide && ent instanceof LivingEntity && !(ent instanceof SeaUrchinEntity) && !(ent instanceof SeaUrchinEggEntity)) {
            ent.hurt(this.damageSources().mobAttack((LivingEntity)this), 2.0f);
        }
    }

    @Override
    public EggEntity createEgg() {
        return new SeaUrchinEggEntity((EntityType<? extends SeaUrchinEggEntity>)((EntityType)TropicraftEntities.SEA_URCHIN_EGG_ENTITY.get()), this.level());
    }

    @Override
    public float getBabyWidth() {
        return 0.25f;
    }

    @Override
    public float getAdultWidth() {
        return 0.5f;
    }

    @Override
    public float getBabyHeight() {
        return 0.25f;
    }

    @Override
    public float getAdultHeight() {
        return 0.5f;
    }

    @Override
    public float getBabyYOffset() {
        return 0.125f;
    }

    @Override
    public float getAdultYOffset() {
        return 0.25f;
    }
}

