/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.underdasea;

import java.util.ArrayList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.BossEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.goal.BreathAirGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.TryFindWaterGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.Nullable;

public class SharkEntity
extends WaterAnimal {
    private static final EntityDataAccessor<Boolean> IS_BOSS = SynchedEntityData.defineId(SharkEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private final ServerBossEvent bossInfo = new ServerBossEvent(this.getDisplayName(), BossEvent.BossBarColor.BLUE, BossEvent.BossBarOverlay.PROGRESS);
    private final ArrayList<ServerPlayer> bossTargets = new ArrayList();
    private boolean hasSetBoss = false;

    public SharkEntity(EntityType<? extends WaterAnimal> type, Level world) {
        super(type, world);
        this.xpReward = 20;
        this.moveControl = new SmoothSwimmingMoveControl((Mob)this, 85, 10, 0.02f, 0.1f, true);
        this.lookControl = new SmoothSwimmingLookControl((Mob)this, 10);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new BreathAirGoal((PathfinderMob)this));
        this.goalSelector.addGoal(0, (Goal)new TryFindWaterGoal((PathfinderMob)this));
        this.goalSelector.addGoal(4, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 10));
        this.goalSelector.addGoal(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, EntitySpawnReason pReason, @Nullable SpawnGroupData pSpawnData) {
        this.setAirSupply(this.getMaxAirSupply());
        return super.finalizeSpawn(pLevel, pDifficulty, pReason, pSpawnData);
    }

    public void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(IS_BOSS, (Object)false);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return WaterAnimal.createMobAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.MOVEMENT_SPEED, 1.2).add(Attributes.ATTACK_DAMAGE, 4.0);
    }

    public void setBoss(boolean boss) {
        this.getEntityData().set(IS_BOSS, (Object)boss);
    }

    public boolean isBoss() {
        return (Boolean)this.getEntityData().get(IS_BOSS);
    }

    private void setBossTraits() {
        this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(8.0);
        this.setCustomName((Component)Component.literal((String)"Elder Hammerhead"));
        this.setCustomNameVisible(true);
        this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(20.0);
        if (!this.level().isClientSide) {
            this.bossInfo.setName((Component)Component.literal((String)"Elder Hammerhead"));
        }
        this.hasSetBoss = true;
    }

    public void tick() {
        super.tick();
    }

    protected PathNavigation createNavigation(Level pLevel) {
        return new WaterBoundPathNavigation((Mob)this, pLevel);
    }

    private void clearBossTargets() {
        if (!this.bossTargets.isEmpty()) {
            for (ServerPlayer p : this.bossTargets) {
                this.bossInfo.removePlayer(p);
            }
            this.bossTargets.clear();
        }
    }

    public void addAdditionalSaveData(ValueOutput output) {
        output.putBoolean("isBoss", this.isBoss());
        super.addAdditionalSaveData(output);
    }

    public void readAdditionalSaveData(ValueInput input) {
        this.setBoss(input.getBooleanOr("isBoss", false));
        super.readAdditionalSaveData(input);
    }

    public boolean removeWhenFarAway(double p) {
        return !this.isBoss() && super.removeWhenFarAway(p);
    }
}

