/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.underdasea;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public abstract class TropicraftFishEntity
extends WaterAnimal {
    public float swimPitch = 0.0f;
    public float swimYaw = 0.0f;
    @Nullable
    public Vec2 targetVectorHeading;
    @Nullable
    public Vec3 targetVector;
    public int outOfWaterTime = 0;
    public float outOfWaterAngle = 0.0f;
    public float fallVelocity = 0.0f;
    public float fallGravity = 0.0625f;
    public float prevSwimPitch = 0.0f;
    public float prevSwimYaw = 0.0f;
    private float swimSpeedDefault = 1.0f;
    protected float swimSpeedCurrent = 0.0f;
    private float swimSpeedPanic = 2.0f;
    private final float swimAccelRate = 0.02f;
    private final float swimDecelRate = 0.02f;
    private float swimSpeedTurn = 5.0f;
    public boolean isMovingAwayFromWall = false;
    public boolean isPanicking = false;
    public boolean fleeFromPlayers = false;
    public boolean approachPlayers = false;
    public double fleeDistance = 2.0;
    public boolean isAggressing = false;
    public final boolean canAggress = false;
    public int eatenFishAmount = 0;
    public final int maximumEatAmount = 5;
    private float swimSpeedChasing = 2.0f;
    private float swimSpeedCharging = 2.5f;
    @Nullable
    public Entity aggressTarget = null;
    private final boolean fishable = false;

    protected TropicraftFishEntity(EntityType<? extends WaterAnimal> type, Level world) {
        super(type, world);
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide) {
            this.setXRot(-this.swimPitch);
            this.setYRot(-this.swimYaw);
            this.yHeadRot = -this.swimYaw;
            this.yHeadRotO = -this.prevSwimYaw;
            this.yBodyRot = 0.0f;
            this.xRotO = -this.prevSwimPitch;
            this.yRotO = -this.prevSwimYaw;
            double x = this.getX() - this.xo;
            double y = this.getY() - this.yo;
            double z = this.getZ() - this.zo;
            this.prevSwimYaw = this.swimYaw;
            this.prevSwimPitch = this.swimPitch;
            float yaw = this.getX() == this.xo && this.getZ() == this.zo ? this.swimYaw : (float)(Math.atan2(z, x) * 180.0 / Math.PI) - 90.0f;
            float pitch = this.getY() == this.yo ? this.swimPitch : (float)(-(Math.atan2(y, Mth.sqrt((float)((float)(x * x + z * z)))) * 180.0 / Math.PI));
            this.swimYaw = this.lerp(this.swimYaw, (int)(-yaw), this.swimSpeedTurn * 4.0f);
            this.swimPitch = this.lerp(this.swimPitch, (int)(-pitch), this.swimSpeedTurn * 4.0f);
            this.setDeltaMovement(this.getDeltaMovement().multiply(0.98, 0.98, 0.98));
            if (this.isNoAi() && this.isInWater()) {
                this.fallVelocity = 0.0f;
                this.swimSpeedCurrent = 0.0f;
                this.setDeltaMovement(Vec3.ZERO);
            }
        }
        if (this.isInWater()) {
            if (this.isMovingAwayFromWall) {
                this.swimSpeedTurn *= 1.8f;
            }
            if (this.targetVectorHeading != null) {
                this.swimYaw = this.lerp(this.swimYaw, -this.targetVectorHeading.x, this.swimSpeedTurn);
                this.swimPitch = this.lerp(this.swimPitch, -this.targetVectorHeading.y, this.swimSpeedTurn);
            }
        }
        if (!this.isInWater()) {
            this.setTargetHeading(this.getX(), this.getY() - 1.0, this.getZ(), false);
        }
        float currentSpeed = this.swimSpeedCurrent;
        float desiredSpeed = this.swimSpeedDefault;
        if (this.aggressTarget != null) {
            desiredSpeed = this.distanceToSqr(this.aggressTarget) < 10.0 ? this.swimSpeedCharging : this.swimSpeedChasing;
        }
        if (this.isPanicking) {
            desiredSpeed = this.swimSpeedPanic;
        }
        if (this.tickCount % 50 < 30) {
            desiredSpeed *= 0.8f;
        }
        if (this.isMovingAwayFromWall) {
            desiredSpeed *= 0.6f;
            currentSpeed *= 0.8f;
        }
        if (this.swimSpeedCurrent < desiredSpeed) {
            this.swimSpeedCurrent += 0.02f;
        }
        if (this.swimSpeedCurrent > desiredSpeed) {
            this.swimSpeedCurrent -= 0.02f;
        }
        currentSpeed *= 0.1f;
        if (this.isInWater()) {
            this.setDeltaMovement((double)currentSpeed * Math.sin((double)this.swimYaw * (Math.PI / 180)), (double)currentSpeed * Math.sin((double)this.swimPitch * (Math.PI / 180)), (double)currentSpeed * Math.cos((double)this.swimYaw * (Math.PI / 180)));
            this.fallVelocity = 0.0f;
        }
        if (this.isNoAi() && this.isInWater()) {
            this.setDeltaMovement(0.0, 0.0, 0.0);
            this.fallVelocity = 0.0f;
            this.swimSpeedCurrent = 0.0f;
        }
        if (this.swimPitch > 45.0f) {
            this.swimPitch = 45.0f;
        }
    }

    public float rangeMap(float input, float inpMin, float inpMax, float outMin, float outMax) {
        if ((double)Math.abs(inpMax - inpMin) < 1.0E-12) {
            return 0.0f;
        }
        double ratio = (outMax - outMin) / (inpMax - inpMin);
        return (float)(ratio * (double)(input - inpMin) + (double)outMin);
    }

    public void setSwimSpeeds(float regular, float panic, float turnSpeed) {
        this.swimSpeedDefault = regular;
        this.swimSpeedPanic = panic;
        this.swimSpeedTurn = turnSpeed;
    }

    public void setSwimSpeeds(float r, float p, float t, float chasing, float charging) {
        this.setSwimSpeeds(r, p, t);
        this.swimSpeedChasing = chasing;
        this.swimSpeedCharging = charging;
    }

    public void setApproachesPlayers(boolean b) {
        this.approachPlayers = b;
    }

    public float lerp(float x1, float x2, float t) {
        return x1 + t * 0.03f * Mth.wrapDegrees((float)(x2 - x1));
    }

    public boolean setTargetHeading(double posX, double posY, double posZ, boolean waterChecks) {
        if (this.isNoAi()) {
            return false;
        }
        if (waterChecks) {
            BlockPos bp = new BlockPos((int)posX, (int)posY, (int)posZ);
            BlockState stateAtPos = this.level().getBlockState(bp);
            if (!stateAtPos.liquid() || stateAtPos.isSolid()) {
                return false;
            }
        }
        double x = (int)(posX - this.getX());
        double y = (int)(posY - this.getY());
        double z = (int)(posZ - this.getZ());
        float yaw = (float)(Math.atan2(z, x) * 180.0 / Math.PI) - 90.0f;
        float pitch = (float)(-(Math.atan2(y, Mth.sqrt((float)((float)(x * x + z * z)))) * 180.0 / Math.PI));
        this.targetVector = new Vec3((double)((int)posX), (double)((int)posY), (double)((int)posZ));
        this.targetVectorHeading = new Vec2(yaw, pitch);
        return true;
    }

    public Vec3 getHeading() {
        return new Vec3(Math.sin((double)this.swimYaw * (Math.PI / 180)), Math.sin((double)this.swimPitch * (Math.PI / 180)), Math.cos((double)this.swimYaw * (Math.PI / 180))).normalize();
    }

    public void setRandomTargetHeadingForce(int maxTimes) {
        for (int i = 0; i < maxTimes && !this.setRandomTargetHeading(); ++i) {
        }
    }

    public boolean setRandomTargetHeading() {
        Player closest;
        boolean result = false;
        int dist = 16;
        Vec3 randBlock = new Vec3(this.getX() + (double)this.randFlip(dist), this.getY() + (double)this.randFlip(dist / 2), this.getZ() + (double)this.randFlip(dist));
        result = this.setTargetHeading(randBlock.x, randBlock.y, randBlock.z, true);
        if (this.approachPlayers && this.random.nextInt(50) == 0 && (closest = this.level().getNearestPlayer((Entity)this, 32.0)) != null && closest.isInWater()) {
            result = this.setTargetHeading(closest.getX(), closest.getY(), closest.getZ(), true);
        }
        return result;
    }

    public void fleeEntity(Entity ent) {
        double x = ent.getX() - this.getX();
        double y = ent.getY() - this.getY();
        double z = ent.getZ() - this.getZ();
        float yaw = (float)(Math.atan2(z, x) * 180.0 / Math.PI) - 90.0f;
        float pitch = (float)(-(Math.atan2(y, Mth.sqrt((float)((float)(x * x + z * z)))) * 180.0 / Math.PI));
        if (this.targetVector == null) {
            this.targetVector = new Vec3(ent.getX(), ent.getY() - 5.0 + (double)this.random.nextInt(10), ent.getZ());
        }
        this.targetVectorHeading = new Vec2(yaw + 180.0f, -1.0f * pitch / 2.0f);
    }

    public int randFlip(int i) {
        return this.random.nextBoolean() ? this.random.nextInt(i) : -this.random.nextInt(i);
    }
}

