/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.underdasea;

import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.AbstractSchoolingFish;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.tropicraft.core.common.entity.underdasea.IAtlasFish;
import net.tropicraft.core.common.item.TropicraftItems;

public class TropicraftTropicalFishEntity
extends AbstractSchoolingFish
implements IAtlasFish {
    private static final EntityDataAccessor<Byte> DATA_FISH_TYPE = SynchedEntityData.defineId(TropicraftTropicalFishEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);

    public TropicraftTropicalFishEntity(EntityType<? extends AbstractSchoolingFish> type, Level world) {
        super(type, world);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return AbstractSchoolingFish.createAttributes().add(Attributes.MAX_HEALTH, 5.0);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_FISH_TYPE, (Object)0);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficultyInstance, EntitySpawnReason spawnReason, @Nullable SpawnGroupData entityData) {
        entityData = super.finalizeSpawn(world, difficultyInstance, spawnReason, entityData);
        this.setFishType(FishType.getRandomType(this.random));
        return entityData;
    }

    public FishType getFishType() {
        return FishType.VALUES[(Byte)this.entityData.get(DATA_FISH_TYPE)];
    }

    public void setFishType(FishType type) {
        this.entityData.set(DATA_FISH_TYPE, (Object)((byte)type.ordinal()));
    }

    public int getMaxSchoolSize() {
        return 24;
    }

    public ItemStack getBucketItemStack() {
        return new ItemStack((ItemLike)TropicraftItems.TROPICAL_FISH_BUCKET.get());
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.SALMON_AMBIENT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.SALMON_DEATH;
    }

    protected SoundEvent getHurtSound(DamageSource dmgSrc) {
        return SoundEvents.SALMON_HURT;
    }

    protected SoundEvent getFlopSound() {
        return SoundEvents.SALMON_FLOP;
    }

    @Override
    public int getAtlasSlot() {
        return this.getFishType().ordinal();
    }

    protected InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!stack.isEmpty() && stack.getItem() == TropicraftItems.FISHING_NET.get()) {
            boolean firstHotbarSlot = false;
            int bucketSlot = -1;
            for (int i = 0; i < Inventory.getSelectionSize(); ++i) {
                ItemStack s = player.getInventory().getItem(0 + i);
                if (!this.isFishHolder(s)) continue;
                bucketSlot = 0 + i;
                break;
            }
            if (bucketSlot == -1 && this.isFishHolder(player.getOffhandItem())) {
                bucketSlot = 36;
            }
            if (bucketSlot >= 0) {
                ItemStack fishHolder = player.getInventory().getItem(bucketSlot);
                if (fishHolder.getItem() == Items.WATER_BUCKET) {
                    fishHolder = new ItemStack((ItemLike)TropicraftItems.TROPICAL_FISH_BUCKET.get());
                    player.getInventory().setItem(bucketSlot, fishHolder);
                }
                this.saveToBucketTag(fishHolder);
                player.swing(hand);
                this.level().playSound((Entity)player, this.blockPosition(), SoundEvents.GENERIC_SWIM, SoundSource.PLAYERS, 0.25f, 1.0f + this.random.nextFloat() * 0.4f);
                this.remove(Entity.RemovalReason.DISCARDED);
                return InteractionResult.SUCCESS;
            }
        }
        return super.mobInteract(player, hand);
    }

    public void addAdditionalSaveData(ValueOutput output) {
        super.addAdditionalSaveData(output);
        output.putInt("FishType", this.getFishType().id);
    }

    public void readAdditionalSaveData(ValueInput input) {
        super.readAdditionalSaveData(input);
        this.setFishType(FishType.getById(input.getIntOr("FishType", 0)));
    }

    public void loadFromBucketTag(CompoundTag nbt) {
        super.loadFromBucketTag(nbt);
        nbt.getInt("BucketVariantTag").ifPresent(id -> this.setFishType(FishType.getById(id)));
    }

    public void saveToBucketTag(ItemStack bucket) {
        super.saveToBucketTag(bucket);
        CustomData.update((DataComponentType)DataComponents.BUCKET_ENTITY_DATA, (ItemStack)bucket, nbt -> nbt.putInt("BucketVariantTag", this.getFishType().id));
    }

    private boolean isFishHolder(ItemStack stack) {
        return stack.is(Items.WATER_BUCKET) || stack.is(TropicraftItems.TROPICAL_FISH_BUCKET);
    }

    static enum FishType {
        CLOWNFISH(0),
        QUEEN_ANGELFISH(1),
        YELLOW_TANG(2),
        BUTTERFLY_FISH(3),
        GEOPHAGUS_SURINAMENSIS(4),
        BETTA_FISH(5),
        REGAL_TANG(6),
        ROYAL_GAMMA(7);

        public static final FishType[] VALUES;
        private final int id;

        private FishType(int id) {
            this.id = id;
        }

        private static FishType getById(int id) {
            for (FishType type : VALUES) {
                if (type.id != id) continue;
                return type;
            }
            return CLOWNFISH;
        }

        private static FishType getRandomType(RandomSource rand) {
            return (FishType)((Object)Util.getRandom((Object[])VALUES, (RandomSource)rand));
        }

        static {
            VALUES = FishType.values();
        }
    }
}

