/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.item;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.component.DataComponents;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class BlowGunItem
extends ProjectileWeaponItem {
    private static final List<MobEffectInstance> EFFECTS = List.of(new MobEffectInstance(MobEffects.SLOWNESS, 60, 20));
    private static final PotionContents POTION_CONTENTS = new PotionContents(Optional.empty(), Optional.empty(), EFFECTS, Optional.empty());

    public BlowGunItem(Item.Properties properties) {
        super(properties);
    }

    public Predicate<ItemStack> getAllSupportedProjectiles() {
        return itemStack -> {
            if (itemStack.getItem() == Items.TIPPED_ARROW) {
                PotionContents contents = (PotionContents)itemStack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
                for (MobEffectInstance effectInstance : contents.getAllEffects()) {
                    if (effectInstance.getEffect() != MobEffects.SLOWNESS) continue;
                    return true;
                }
            }
            return false;
        };
    }

    public int getDefaultProjectileRange() {
        return 8;
    }

    protected void shootProjectile(LivingEntity pShooter, Projectile pProjectile, int pIndex, float pVelocity, float pInaccuracy, float pAngle, @Nullable LivingEntity pTarget) {
    }

    public InteractionResult use(Level world, Player player, InteractionHand hand) {
        ItemStack heldStack = player.getItemInHand(hand);
        ItemStack ammo = BlowGunItem.getAmmo((LivingEntity)player, heldStack);
        if (!ammo.isEmpty()) {
            BlowGunItem.fireProjectile(world, (LivingEntity)player, hand, heldStack, ammo, 1.0f, player.getAbilities().instabuild, 10.0f, 0.0f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    private static ItemStack getAmmo(LivingEntity entityIn, ItemStack stack) {
        boolean isCreativeMode = entityIn instanceof Player && ((Player)entityIn).getAbilities().instabuild;
        ItemStack ammo = entityIn.getProjectile(stack);
        if (isCreativeMode) {
            return BlowGunItem.getProjectile();
        }
        if (!ammo.isEmpty()) {
            return ammo;
        }
        return ItemStack.EMPTY;
    }

    public static ItemStack getProjectile() {
        ItemStack itemStack = new ItemStack((ItemLike)Items.TIPPED_ARROW);
        itemStack.set(DataComponents.POTION_CONTENTS, (Object)POTION_CONTENTS);
        return itemStack;
    }

    public static void fireProjectile(Level world, LivingEntity shooter, InteractionHand hand, ItemStack heldItem, ItemStack projectile, float soundPitch, boolean isCreativeMode, float dmg, float pitch) {
        if (!world.isClientSide) {
            Arrow arrowEntity = BlowGunItem.createArrow(world, shooter, projectile, heldItem);
            if (isCreativeMode) {
                arrowEntity.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
            }
            Vector3f look = shooter.getViewVector(1.0f).toVector3f();
            arrowEntity.shoot((double)look.x(), (double)look.y(), (double)look.z(), dmg, pitch);
            heldItem.hurtAndBreak(1, shooter, LivingEntity.getSlotForHand((InteractionHand)hand));
            projectile.split(1);
            if (projectile.isEmpty() && shooter instanceof Player) {
                ((Player)shooter).getInventory().removeItem(projectile);
            }
            world.addFreshEntity((Entity)arrowEntity);
            world.playSound(null, shooter.getX(), shooter.getY(), shooter.getZ(), SoundEvents.CROSSBOW_SHOOT, SoundSource.PLAYERS, 1.0f, soundPitch);
        }
    }

    public static Arrow createArrow(Level world, LivingEntity shooter, ItemStack projectile, ItemStack weapon) {
        ItemStack projectileWithEffects = projectile.copy();
        projectileWithEffects.set(DataComponents.POTION_CONTENTS, (Object)POTION_CONTENTS);
        ArrowItem arrowItem = (ArrowItem)(projectile.getItem() instanceof ArrowItem ? projectile.getItem() : Items.ARROW);
        Arrow arrowEntity = (Arrow)arrowItem.createArrow(world, projectileWithEffects, shooter, weapon);
        arrowEntity.setBaseDamage(0.0);
        arrowEntity.setSoundEvent(SoundEvents.CROSSBOW_HIT);
        arrowEntity.setCritArrow(false);
        return arrowEntity;
    }
}

