/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.item;

import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.tropicraft.core.common.drinks.Cocktail;
import net.tropicraft.core.common.drinks.Drink;
import net.tropicraft.core.common.drinks.TropicraftDrinks;
import net.tropicraft.core.common.item.TropicraftItems;
import net.tropicraft.core.common.item.component.TropicraftDataComponents;

public class CocktailItem
extends Item {
    public CocktailItem(Item.Properties properties) {
        super(properties.component(TropicraftDataComponents.COCKTAIL, (Object)Cocktail.EMPTY));
    }

    public static Cocktail getCocktail(ItemStack itemStack) {
        return (Cocktail)itemStack.getOrDefault(TropicraftDataComponents.COCKTAIL, (Object)Cocktail.EMPTY);
    }

    public static ItemStack makeCocktail(Cocktail cocktail) {
        ItemStack stack = new ItemStack((ItemLike)TropicraftItems.COCKTAIL.get());
        stack.set(TropicraftDataComponents.COCKTAIL, (Object)cocktail);
        return stack;
    }

    public static ItemStack makeDrink(Holder<Drink> drink) {
        return CocktailItem.makeCocktail(Cocktail.ofDrink(drink));
    }

    @Nullable
    public static Holder<Drink> getDrink(ItemStack itemStack) {
        return CocktailItem.getCocktail(itemStack).drink().orElse(null);
    }

    public static boolean hasDrink(ItemStack itemStack, ResourceKey<Drink> drink) {
        Holder<Drink> actualDrink = CocktailItem.getDrink(itemStack);
        return actualDrink != null && actualDrink.is(drink);
    }

    public static boolean isDrink(ItemStack itemStack) {
        return !CocktailItem.getCocktail(itemStack).equals(Cocktail.EMPTY);
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 32;
    }

    public ItemUseAnimation getUseAnimation(ItemStack stack) {
        return ItemUseAnimation.DRINK;
    }

    public ItemStack onFoodEaten(ItemStack itemstack, Level world, Player player) {
        world.playSound((Entity)player, player.getX(), player.getY(), player.getZ(), SoundEvents.PLAYER_BURP, SoundSource.PLAYERS, 0.5f, world.random.nextFloat() * 0.1f + 0.9f);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Cocktail cocktail = (Cocktail)itemstack.get(TropicraftDataComponents.COCKTAIL);
            if (cocktail != null) {
                cocktail.onDrink(serverPlayer);
            }
            CriteriaTriggers.CONSUME_ITEM.trigger(serverPlayer, itemstack);
        }
        return new ItemStack((ItemLike)TropicraftItems.BAMBOO_MUG.get());
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            this.onFoodEaten(stack, level, player);
            if (!level.isRainingAt(player.blockPosition()) || CocktailItem.hasDrink(stack, TropicraftDrinks.PINA_COLADA)) {
                // empty if block
            }
            return player.getAbilities().instabuild ? stack : new ItemStack((ItemLike)TropicraftItems.BAMBOO_MUG.get());
        }
        return new ItemStack((ItemLike)TropicraftItems.BAMBOO_MUG.get());
    }

    public InteractionResult use(Level worldIn, Player playerIn, InteractionHand hand) {
        ItemStack stack = playerIn.getItemInHand(hand);
        if (!CocktailItem.isDrink(stack)) {
            return InteractionResult.FAIL;
        }
        playerIn.startUsingItem(hand);
        return InteractionResult.SUCCESS;
    }

    public Component getName(ItemStack stack) {
        Holder<Drink> drink = CocktailItem.getDrink(stack);
        if (drink != null) {
            return ComponentUtils.mergeStyles((MutableComponent)((Drink)drink.value()).name().copy(), (Style)Style.EMPTY.withBold(Boolean.valueOf(true)));
        }
        return super.getName(stack);
    }
}

