/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.item;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.tropicraft.core.common.entity.placeable.FurnitureEntity;

public class FurnitureItem<T extends FurnitureEntity>
extends Item {
    private final Supplier<? extends EntityType<T>> entityType;
    private final DyeColor color;

    public FurnitureItem(Item.Properties properties, Supplier<? extends EntityType<T>> entityType, DyeColor color) {
        super(properties);
        this.entityType = entityType;
        this.color = color;
    }

    public InteractionResult use(Level level, Player placer, InteractionHand hand) {
        ItemStack heldItem = placer.getItemInHand(hand);
        BlockHitResult rayTraceResult = FurnitureItem.getPlayerPOVHitResult((Level)level, (Player)placer, (ClipContext.Fluid)ClipContext.Fluid.ANY);
        if (rayTraceResult.getType() == HitResult.Type.MISS) {
            return InteractionResult.PASS;
        }
        Vec3 viewVector = placer.getViewVector(1.0f);
        List nearbyEntities = level.getEntities((Entity)placer, placer.getBoundingBox().expandTowards(viewVector.scale(5.0)).inflate(1.0), EntitySelector.NO_SPECTATORS);
        if (!nearbyEntities.isEmpty()) {
            Vec3 eyePosition = placer.getEyePosition(1.0f);
            for (Entity nearbyEnt : nearbyEntities) {
                AABB nearbyBB = nearbyEnt.getBoundingBox().inflate((double)nearbyEnt.getPickRadius());
                if (!nearbyBB.contains(eyePosition)) continue;
                return InteractionResult.PASS;
            }
        }
        if (rayTraceResult.getType() == HitResult.Type.BLOCK) {
            Vec3 hitVec = rayTraceResult.getLocation();
            FurnitureEntity entity = (FurnitureEntity)this.entityType.get().create(level, EntitySpawnReason.SPAWN_ITEM_USE);
            entity.snapTo(BlockPos.containing((Position)hitVec), placer.getYRot() + 180.0f, 0.0f);
            if (level instanceof ServerLevel) {
                ServerLevel serverlevel = (ServerLevel)level;
                EntityType.createDefaultStackConfig((Level)serverlevel, (ItemStack)heldItem, (LivingEntity)placer).accept(entity);
            }
            entity.setDeltaMovement(Vec3.ZERO);
            entity.setColor(this.color);
            if (!level.noCollision((Entity)entity, entity.getBoundingBox().inflate(-0.1))) {
                return InteractionResult.FAIL;
            }
            if (!level.isClientSide) {
                level.addFreshEntity((Entity)entity);
            }
            heldItem.consume(1, (LivingEntity)placer);
            placer.awardStat(Stats.ITEM_USED.get((Object)this));
            return InteractionResult.SUCCESS.heldItemTransformedTo(heldItem);
        }
        return InteractionResult.PASS;
    }
}

