/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.item;

import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public class TropicalFertilizerItem
extends BoneMealItem {
    public TropicalFertilizerItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockState state = context.getLevel().getBlockState(context.getClickedPos());
        if (state.is(Blocks.GRASS_BLOCK)) {
            if (!context.getLevel().isClientSide) {
                BlockPos blockpos = context.getClickedPos().above();
                BlockState blockstate = Blocks.TALL_GRASS.defaultBlockState();
                Level level = context.getLevel();
                RandomSource rand = level.getRandom();
                Optional grassBonemeal = level.registryAccess().lookupOrThrow(Registries.PLACED_FEATURE).get(VegetationPlacements.GRASS_BONEMEAL);
                block0: for (int i = 0; i < 128; ++i) {
                    BlockPos blockpos1 = blockpos;
                    int j = 0;
                    while (true) {
                        if (j >= i / 16) {
                            Holder holder;
                            BlockState blockstate2 = level.getBlockState(blockpos1);
                            if (blockstate2.is(blockstate.getBlock()) && rand.nextInt(10) == 0 && level instanceof ServerLevel) {
                                ((BonemealableBlock)blockstate.getBlock()).performBonemeal((ServerLevel)level, rand, blockpos1, blockstate2);
                            }
                            if (!blockstate2.isAir()) continue block0;
                            if (rand.nextInt(8) > 0) {
                                List list = ((Biome)level.getBiome(blockpos1).value()).getGenerationSettings().getFlowerFeatures();
                                if (list.isEmpty()) continue block0;
                                holder = ((RandomPatchConfiguration)((ConfiguredFeature)list.getFirst()).config()).feature();
                            } else {
                                if (grassBonemeal.isEmpty()) continue;
                                holder = (Holder)grassBonemeal.get();
                            }
                            if (!(level instanceof ServerLevel)) continue block0;
                            ServerLevel serverLevel = (ServerLevel)level;
                            ((PlacedFeature)holder.value()).place((WorldGenLevel)serverLevel, serverLevel.getChunkSource().getGenerator(), rand, blockpos1);
                            continue block0;
                        }
                        if (level.getBlockState((blockpos1 = blockpos1.offset(rand.nextInt(3) - 1, (rand.nextInt(3) - 1) * rand.nextInt(3) / 2, rand.nextInt(3) - 1)).below()).getBlock() != Blocks.GRASS_BLOCK || level.getBlockState(blockpos1).isCollisionShapeFullBlock((BlockGetter)level, blockpos1)) continue block0;
                        ++j;
                    }
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.useOn(context);
    }
}

