/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.item;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MobBucketItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;

public class TropicraftFishBucketItem<T extends AbstractFish>
extends MobBucketItem {
    private final EntityType<T> fishType;

    public TropicraftFishBucketItem(EntityType<T> type, Fluid fluid, Item.Properties props) {
        super(type, fluid, SoundEvents.BUCKET_FILL_FISH, props);
        this.fishType = type;
    }

    public void checkExtraContent(@Nullable LivingEntity user, Level level, ItemStack stack, BlockPos pos) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.placeFish(serverLevel, stack, pos);
        }
    }

    private void placeFish(ServerLevel world, ItemStack stack, BlockPos pos) {
        AbstractFish fishy = (AbstractFish)this.fishType.spawn(world, stack, null, pos, EntitySpawnReason.BUCKET, true, false);
        if (fishy != null) {
            fishy.setFromBucket(true);
        }
    }
}

