/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.item;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.tterrag.registrate.Registrate;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.GeneratorType;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.providers.generators.RegistrateItemModelGenerator;
import com.tterrag.registrate.util.DataIngredient;
import com.tterrag.registrate.util.entry.ItemEntry;
import com.tterrag.registrate.util.entry.RegistryEntry;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.advancements.critereon.DamageSourcePredicate;
import net.minecraft.advancements.critereon.TagPredicate;
import net.minecraft.client.color.item.Constant;
import net.minecraft.client.color.item.ItemTintSource;
import net.minecraft.client.data.models.ItemModelGenerators;
import net.minecraft.client.data.models.model.ItemModelUtils;
import net.minecraft.client.data.models.model.ModelLocationUtils;
import net.minecraft.client.data.models.model.ModelTemplate;
import net.minecraft.client.data.models.model.ModelTemplates;
import net.minecraft.client.data.models.model.TextureMapping;
import net.minecraft.client.data.models.model.TextureSlot;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.client.renderer.item.SelectItemModel;
import net.minecraft.client.renderer.item.properties.conditional.ConditionalItemModelProperty;
import net.minecraft.client.renderer.item.properties.select.DisplayContext;
import net.minecraft.client.renderer.item.properties.select.SelectItemModelProperty;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.EitherHolder;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.JukeboxPlayable;
import net.minecraft.world.item.JukeboxSong;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SignItem;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.ToolMaterial;
import net.minecraft.world.item.component.Consumable;
import net.minecraft.world.item.component.Consumables;
import net.minecraft.world.item.equipment.ArmorMaterial;
import net.minecraft.world.item.equipment.ArmorType;
import net.minecraft.world.item.equipment.EquipmentAsset;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.registries.RegisterEvent;
import net.tropicraft.Tropicraft;
import net.tropicraft.core.client.TropicraftEquipmentAssets;
import net.tropicraft.core.client.TropicraftItemTintSources;
import net.tropicraft.core.common.Foods;
import net.tropicraft.core.common.TropicraftRegistries;
import net.tropicraft.core.common.TropicraftTags;
import net.tropicraft.core.common.attribute.TropicraftAttributes;
import net.tropicraft.core.common.block.TropicraftBlocks;
import net.tropicraft.core.common.block.TropicraftFlower;
import net.tropicraft.core.common.block.TropicraftWoodTypes;
import net.tropicraft.core.common.drinks.Cocktail;
import net.tropicraft.core.common.drinks.Drink;
import net.tropicraft.core.common.drinks.TropicraftDrinks;
import net.tropicraft.core.common.entity.TropicraftEntities;
import net.tropicraft.core.common.entity.placeable.BeachFloatEntity;
import net.tropicraft.core.common.entity.placeable.ChairEntity;
import net.tropicraft.core.common.entity.placeable.FurnitureEntity;
import net.tropicraft.core.common.entity.placeable.UmbrellaEntity;
import net.tropicraft.core.common.item.AshenMaskItem;
import net.tropicraft.core.common.item.AshenMasks;
import net.tropicraft.core.common.item.BambooItemFrameItem;
import net.tropicraft.core.common.item.BlowGunItem;
import net.tropicraft.core.common.item.CocktailItem;
import net.tropicraft.core.common.item.DaggerItem;
import net.tropicraft.core.common.item.ExplodingCoconutItem;
import net.tropicraft.core.common.item.FurnitureItem;
import net.tropicraft.core.common.item.LoveTropicsShellItem;
import net.tropicraft.core.common.item.ShellItem;
import net.tropicraft.core.common.item.SpearItem;
import net.tropicraft.core.common.item.TropicalFertilizerItem;
import net.tropicraft.core.common.item.TropicraftArmorMaterials;
import net.tropicraft.core.common.item.TropicraftFishBucketItem;
import net.tropicraft.core.common.item.TropicraftJukeboxSongs;
import net.tropicraft.core.common.item.TropicraftToolMaterials;
import net.tropicraft.core.common.item.WaterWandItem;
import net.tropicraft.core.common.item.component.DamageModifier;
import net.tropicraft.core.common.item.component.TropicraftDataComponents;
import net.tropicraft.core.common.item.scuba.PonyBottleItem;
import net.tropicraft.core.common.item.scuba.ScubaArmorItem;
import net.tropicraft.core.common.item.scuba.ScubaHarnessItem;
import net.tropicraft.core.common.item.scuba.ScubaType;

public class TropicraftItems {
    public static final Registrate REGISTRATE = Tropicraft.registrate();
    private static final Map<DyeColor, Item> WOOL_BY_DYE = Map.ofEntries(Map.entry(DyeColor.BLACK, Items.BLACK_WOOL), Map.entry(DyeColor.BLUE, Items.BLUE_WOOL), Map.entry(DyeColor.BROWN, Items.BROWN_WOOL), Map.entry(DyeColor.CYAN, Items.CYAN_WOOL), Map.entry(DyeColor.GRAY, Items.GRAY_WOOL), Map.entry(DyeColor.GREEN, Items.GREEN_WOOL), Map.entry(DyeColor.LIGHT_BLUE, Items.LIGHT_BLUE_WOOL), Map.entry(DyeColor.LIGHT_GRAY, Items.LIGHT_GRAY_WOOL), Map.entry(DyeColor.LIME, Items.LIME_WOOL), Map.entry(DyeColor.MAGENTA, Items.MAGENTA_WOOL), Map.entry(DyeColor.ORANGE, Items.ORANGE_WOOL), Map.entry(DyeColor.PINK, Items.PINK_WOOL), Map.entry(DyeColor.PURPLE, Items.PURPLE_WOOL), Map.entry(DyeColor.RED, Items.RED_WOOL), Map.entry(DyeColor.YELLOW, Items.YELLOW_WOOL), Map.entry(DyeColor.WHITE, Items.WHITE_WOOL));
    public static final ItemEntry<Item> AZURITE;
    public static final ItemEntry<Item> EUDIALYTE;
    public static final ItemEntry<Item> ZIRCON;
    public static final ItemEntry<Item> SHAKA;
    public static final ItemEntry<Item> MANGANESE;
    public static final ItemEntry<Item> ZIRCONIUM;
    public static final Map<DyeColor, ItemEntry<FurnitureItem<UmbrellaEntity>>> UMBRELLAS;
    public static final Map<DyeColor, ItemEntry<FurnitureItem<ChairEntity>>> CHAIRS;
    public static final Map<DyeColor, ItemEntry<FurnitureItem<BeachFloatEntity>>> BEACH_FLOATS;
    public static final ItemEntry<Item> BAMBOO_STICK;
    public static final ItemEntry<SpearItem> BAMBOO_SPEAR;
    public static final ItemEntry<ShellItem> SOLONOX_SHELL;
    public static final ItemEntry<ShellItem> FROX_CONCH;
    public static final ItemEntry<ShellItem> PAB_SHELL;
    public static final ItemEntry<ShellItem> RUBE_NAUTILUS;
    public static final ItemEntry<ShellItem> STARFISH;
    public static final ItemEntry<ShellItem> TURTLE_SHELL;
    public static final ItemEntry<LoveTropicsShellItem> LOVE_TROPICS_SHELL;
    private static final Consumable FAST_FOOD;
    public static final ItemEntry<Item> LEMON;
    public static final ItemEntry<Item> LIME;
    public static final ItemEntry<Item> GRAPEFRUIT;
    public static final ItemEntry<Item> ORANGE;
    public static final ItemEntry<Item> PASSIONFRUIT;
    public static final ItemEntry<Item> JOCOTE;
    public static final ItemEntry<BlockItem> PAPAYA;
    public static final ItemEntry<Item> PINEAPPLE_CUBES;
    public static final ItemEntry<Item> COCONUT_CHUNK;
    public static final ItemEntry<BlockItem> RAW_COFFEE_BEAN;
    public static final ItemEntry<Item> ROASTED_COFFEE_BEAN;
    public static final ItemEntry<Item> COFFEE_BERRY;
    public static final ItemEntry<Item> BAMBOO_MUG;
    public static final ItemEntry<Item> BAMBOO_BOWL;
    public static final ItemEntry<Item> GREEN_PLANTAIN;
    public static final ItemEntry<Item> YELLOW_PLANTAIN;
    public static final ItemEntry<Item> DRIED_PLANTAINS;
    public static final ItemEntry<Item> MOFONGO;
    public static final ItemEntry<CocktailItem> COCKTAIL;
    public static final ItemEntry<Item> WHITE_PEARL;
    public static final ItemEntry<Item> BLACK_PEARL;
    public static final ItemEntry<Item> SCALE;
    public static final ItemEntry<Item> NIGEL_STACHE;
    public static final ItemEntry<Item> COOL_SHADES;
    public static final ItemEntry<Item> FRESH_MARLIN;
    public static final ItemEntry<Item> SEARED_MARLIN;
    public static final ItemEntry<Item> RAW_RAY;
    public static final ItemEntry<Item> COOKED_RAY;
    public static final ItemEntry<Item> FROG_LEG;
    public static final ItemEntry<Item> COOKED_FROG_LEG;
    public static final ItemEntry<Item> SEA_URCHIN_ROE;
    public static final ItemEntry<Item> TOASTED_NORI;
    public static final ItemEntry<Item> RAW_FISH;
    public static final ItemEntry<Item> COOKED_FISH;
    public static final ItemEntry<Item> POISON_FROG_SKIN;
    public static final ItemEntry<Item> IGUANA_LEATHER;
    public static final ItemEntry<TropicalFertilizerItem> TROPICAL_FERTILIZER;
    public static final ItemEntry<BambooItemFrameItem> BAMBOO_ITEM_FRAME;
    public static final ItemEntry<Item> MUSIC_DISC_BURIED_TREASURE;
    public static final ItemEntry<Item> MUSIC_DISC_EASTERN_ISLES;
    public static final ItemEntry<Item> MUSIC_DISC_THE_TRIBE;
    public static final ItemEntry<Item> MUSIC_DISC_LOW_TIDE;
    public static final ItemEntry<Item> MUSIC_DISC_TRADE_WINDS;
    public static final ItemEntry<Item> MUSIC_DISC_SUMMERING;
    public static final ItemEntry<Item> TROPICAL_FISH_BUCKET;
    public static final ItemEntry<Item> SARDINE_BUCKET;
    public static final ItemEntry<Item> PIRANHA_BUCKET;
    public static final ItemEntry<Item> KOA_SPAWN_EGG;
    public static final ItemEntry<Item> TROPICREEPER_SPAWN_EGG;
    public static final ItemEntry<Item> IGUANA_SPAWN_EGG;
    public static final ItemEntry<Item> TROPISKELLY_SPAWN_EGG;
    public static final ItemEntry<Item> EIH_SPAWN_EGG;
    public static final ItemEntry<Item> SEA_TURTLE_SPAWN_EGG;
    public static final ItemEntry<Item> MARLIN_SPAWN_EGG;
    public static final ItemEntry<Item> FAILGULL_SPAWN_EGG;
    public static final ItemEntry<Item> DOLPHIN_SPAWN_EGG;
    public static final ItemEntry<Item> SEAHORSE_SPAWN_EGG;
    public static final ItemEntry<Item> TREE_FROG_SPAWN_EGG;
    public static final ItemEntry<Item> SEA_URCHIN_SPAWN_EGG;
    public static final ItemEntry<Item> V_MONKEY_SPAWN_EGG;
    public static final ItemEntry<Item> PIRANHA_SPAWN_EGG;
    public static final ItemEntry<Item> SARDINE_SPAWN_EGG;
    public static final ItemEntry<Item> TROPICAL_FISH_SPAWN_EGG;
    public static final ItemEntry<Item> EAGLE_RAY_SPAWN_EGG;
    public static final ItemEntry<Item> TROPI_SPIDER_SPAWN_EGG;
    public static final ItemEntry<Item> ASHEN_SPAWN_EGG;
    public static final ItemEntry<Item> HAMMERHEAD_SPAWN_EGG;
    public static final ItemEntry<Item> COWKTAIL_SPAWN_EGG;
    public static final ItemEntry<Item> MAN_O_WAR_SPAWN_EGG;
    public static final ItemEntry<Item> TROPIBEE_SPAWN_EGG;
    public static final ItemEntry<Item> TAPIR_SPAWN_EGG;
    public static final ItemEntry<Item> JAGUAR_SPAWN_EGG;
    public static final ItemEntry<Item> BROWN_BASILISK_LIZARD_SPAWN_EGG;
    public static final ItemEntry<Item> GREEN_BASILISK_LIZARD_SPAWN_EGG;
    public static final ItemEntry<Item> HUMMINGBIRD_SPAWN_EGG;
    public static final ItemEntry<Item> FIDDLER_CRAB_SPAWN_EGG;
    public static final ItemEntry<Item> SPIDER_MONKEY_SPAWN_EGG;
    public static final ItemEntry<Item> WHITE_LIPPED_PECCARY_SPAWN_EGG;
    public static final ItemEntry<Item> CUBERA_SPAWN_EGG;
    public static final ItemEntry<Item> GIBNUT_SPAWN_EGG;
    public static final ItemEntry<Item> MANATEE_SPAWN_EGG;
    public static final ItemEntry<Item> SLENDER_HARVEST_MOUSE_SPAWN_EGG;
    public static final ItemEntry<Item> TOUCAN_SPAWN_EGG;
    public static final ItemEntry<Item> PAPYRUS_CANARY_SPAWN_EGG;
    public static final ItemEntry<Item> PAPYRUS_GONOLEK_SPAWN_EGG;
    public static final ItemEntry<Item> SHOEBILL_STORK_SPAWN_EGG;
    public static final ItemEntry<Item> WHITE_COLLARED_OLIVEBACK_SPAWN_EGG;
    public static final ItemEntry<Item> WHITE_WINGED_WARBLER_SPAWN_EGG;
    public static final ItemEntry<Item> STARFISH_SPAWN_EGG;
    public static final ImmutableMap<AshenMasks, ItemEntry<AshenMaskItem>> ASHEN_MASKS;
    public static final ItemEntry<Item> DAGGER;
    public static final ItemEntry<BlowGunItem> BLOW_GUN;
    public static final ItemEntry<Item> ZIRCON_HOE;
    public static final ItemEntry<Item> ZIRCONIUM_HOE;
    public static final ItemEntry<Item> EUDIALYTE_HOE;
    public static final ItemEntry<Item> ZIRCON_AXE;
    public static final ItemEntry<Item> ZIRCONIUM_AXE;
    public static final ItemEntry<Item> EUDIALYTE_AXE;
    public static final ItemEntry<Item> ZIRCON_PICKAXE;
    public static final ItemEntry<Item> ZIRCONIUM_PICKAXE;
    public static final ItemEntry<Item> EUDIALYTE_PICKAXE;
    public static final ItemEntry<Item> ZIRCON_SHOVEL;
    public static final ItemEntry<Item> ZIRCONIUM_SHOVEL;
    public static final ItemEntry<Item> EUDIALYTE_SHOVEL;
    public static final ItemEntry<Item> ZIRCON_SWORD;
    public static final ItemEntry<Item> ZIRCONIUM_SWORD;
    public static final ItemEntry<Item> EUDIALYTE_SWORD;
    public static final ItemEntry<Item> FIRE_BOOTS;
    public static final ItemEntry<Item> FIRE_LEGGINGS;
    public static final ItemEntry<Item> FIRE_CHESTPLATE;
    public static final ItemEntry<Item> FIRE_HELMET;
    public static final ItemEntry<Item> SCALE_BOOTS;
    public static final ItemEntry<Item> SCALE_LEGGINGS;
    public static final ItemEntry<Item> SCALE_CHESTPLATE;
    public static final ItemEntry<Item> SCALE_HELMET;
    public static final ItemEntry<Item> YELLOW_SCUBA_GOGGLES;
    public static final ItemEntry<ScubaHarnessItem> YELLOW_SCUBA_HARNESS;
    public static final ItemEntry<Item> YELLOW_SCUBA_FLIPPERS;
    public static final ItemEntry<Item> PINK_SCUBA_GOGGLES;
    public static final ItemEntry<ScubaHarnessItem> PINK_SCUBA_HARNESS;
    public static final ItemEntry<Item> PINK_SCUBA_FLIPPERS;
    public static final ItemEntry<PonyBottleItem> YELLOW_PONY_BOTTLE;
    public static final ItemEntry<PonyBottleItem> PINK_PONY_BOTTLE;
    public static final ItemEntry<WaterWandItem> WATER_WAND;
    public static final ItemEntry<ExplodingCoconutItem> EXPLODING_COCONUT;
    public static final ItemEntry<Item> FISHING_NET;
    public static final ItemEntry<Item> PIANGUAS;
    public static final ItemEntry<SignItem> MAHOGANY_SIGN;
    public static final ItemEntry<SignItem> PALM_SIGN;
    public static final ItemEntry<SignItem> BAMBOO_SIGN;
    public static final ItemEntry<SignItem> THATCH_SIGN;
    public static final ItemEntry<SignItem> MANGROVE_SIGN;

    private static <T extends FurnitureEntity> ItemBuilder<FurnitureItem<T>, Registrate> furniture(String baseName, Supplier<EntityType<T>> type, DyeColor color) {
        return REGISTRATE.item(color.getSerializedName() + "_" + baseName, p -> new FurnitureItem((Item.Properties)p, type, color)).model(() -> (ctx, prov) -> Models.generateFurniture(ctx, prov, baseName, color));
    }

    private static ItemBuilder<ShellItem, Registrate> shell(String name) {
        return REGISTRATE.item(name, ShellItem::new).tag(new TagKey[]{TropicraftTags.Items.SHELLS});
    }

    private static ItemBuilder<Item, Registrate> musicDisc(ResourceKey<JukeboxSong> song) {
        return REGISTRATE.item("music_disc_" + song.location().getPath(), Item::new).properties(p -> p.rarity(Rarity.RARE).component(DataComponents.JUKEBOX_PLAYABLE, (Object)new JukeboxPlayable(new EitherHolder(song)))).lang("Music Disc").tag(new TagKey[]{Tags.Items.MUSIC_DISCS});
    }

    private static <T extends AbstractFish> ItemBuilder<Item, Registrate> fishBucket(String name, Supplier<? extends EntityType<T>> entity) {
        return REGISTRATE.item(name, p -> new TropicraftFishBucketItem((EntityType)entity.get(), (Fluid)Fluids.WATER, (Item.Properties)p)).properties(p -> p.stacksTo(1));
    }

    private static <T extends Mob> ItemBuilder<Item, Registrate> spawnEgg(String name, RegistryEntry<EntityType<?>, EntityType<T>> entity) {
        return REGISTRATE.item(name, p -> new SpawnEggItem((EntityType)entity.get(), p));
    }

    private static ItemBuilder<Item, Registrate> hoe(String name, ToolMaterial material, Supplier<? extends Item> input) {
        return REGISTRATE.item(name, p -> new HoeItem(material, 3.0f, -2.4f, p)).tag(new TagKey[]{ItemTags.HOES}).model(() -> Models::generateHandheld).recipe((ctx, prov) -> ShapedRecipeBuilder.shaped((HolderGetter)prov.itemLookup(), (RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)ctx.get())).pattern("XX").pattern(" B").pattern(" B").define(Character.valueOf('X'), (ItemLike)input.get()).define(Character.valueOf('B'), (ItemLike)BAMBOO_STICK.get()).unlockedBy("has_" + prov.safeName((ItemLike)input.get()), prov.has((ItemLike)input.get())).unlockedBy("has_" + prov.safeName((ItemLike)Items.BAMBOO), prov.has((ItemLike)Items.BAMBOO)).save((RecipeOutput)prov));
    }

    private static ItemBuilder<Item, Registrate> shovel(String name, ToolMaterial material, Supplier<? extends Item> input) {
        return REGISTRATE.item(name, p -> new ShovelItem(material, 1.5f, -3.0f, p)).tag(new TagKey[]{ItemTags.SHOVELS}).model(() -> Models::generateHandheld).recipe((ctx, prov) -> ShapedRecipeBuilder.shaped((HolderGetter)prov.itemLookup(), (RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)ctx.get())).pattern("X").pattern("B").pattern("B").define(Character.valueOf('X'), (ItemLike)input.get()).define(Character.valueOf('B'), (ItemLike)BAMBOO_STICK.get()).unlockedBy("has_" + prov.safeName((ItemLike)input.get()), prov.has((ItemLike)input.get())).unlockedBy("has_" + prov.safeName((ItemLike)Items.BAMBOO), prov.has((ItemLike)Items.BAMBOO)).save((RecipeOutput)prov));
    }

    private static ItemBuilder<Item, Registrate> pickaxe(String name, ToolMaterial material, Supplier<? extends Item> input) {
        return REGISTRATE.item(name, Item::new).properties(p -> p.pickaxe(material, 1.0f, -2.8f)).tag(new TagKey[]{ItemTags.PICKAXES}).model(() -> Models::generateHandheld).recipe((ctx, prov) -> ShapedRecipeBuilder.shaped((HolderGetter)prov.itemLookup(), (RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)ctx.get())).pattern("XXX").pattern(" B ").pattern(" B ").define(Character.valueOf('X'), (ItemLike)input.get()).define(Character.valueOf('B'), (ItemLike)BAMBOO_STICK.get()).unlockedBy("has_" + prov.safeName((ItemLike)input.get()), prov.has((ItemLike)input.get())).unlockedBy("has_" + prov.safeName((ItemLike)Items.BAMBOO), prov.has((ItemLike)Items.BAMBOO)).save((RecipeOutput)prov));
    }

    private static ItemBuilder<Item, Registrate> axe(String name, ToolMaterial material, Supplier<? extends Item> input) {
        return REGISTRATE.item(name, p -> new AxeItem(material, 6.0f, -3.0f, p)).tag(new TagKey[]{ItemTags.AXES}).model(() -> Models::generateHandheld).recipe((ctx, prov) -> ShapedRecipeBuilder.shaped((HolderGetter)prov.itemLookup(), (RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)ctx.get())).pattern("XX").pattern("XB").pattern(" B").define(Character.valueOf('X'), (ItemLike)input.get()).define(Character.valueOf('B'), (ItemLike)BAMBOO_STICK.get()).unlockedBy("has_" + prov.safeName((ItemLike)input.get()), prov.has((ItemLike)input.get())).unlockedBy("has_" + prov.safeName((ItemLike)Items.BAMBOO), prov.has((ItemLike)Items.BAMBOO)).save((RecipeOutput)prov));
    }

    private static ItemBuilder<Item, Registrate> sword(String name, ToolMaterial material, Supplier<? extends Item> input) {
        return REGISTRATE.item(name, Item::new).properties(p -> p.sword(material, 3.0f, -2.4f)).tag(new TagKey[]{ItemTags.SWORDS}).model(() -> Models::generateHandheld).recipe((ctx, prov) -> ShapedRecipeBuilder.shaped((HolderGetter)prov.itemLookup(), (RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ctx.get())).pattern("X").pattern("X").pattern("B").define(Character.valueOf('X'), (ItemLike)input.get()).define(Character.valueOf('B'), (ItemLike)BAMBOO_STICK.get()).unlockedBy("has_" + prov.safeName((ItemLike)input.get()), prov.has((ItemLike)input.get())).unlockedBy("has_" + prov.safeName((ItemLike)Items.BAMBOO), prov.has((ItemLike)Items.BAMBOO)).save((RecipeOutput)prov));
    }

    private static ItemBuilder<Item, Registrate> fireArmor(String name, ArmorType slotType) {
        return TropicraftItems.simpleItem(name).properties(p -> TropicraftArmorMaterials.applySafe(p, TropicraftArmorMaterials.FIRE_ARMOR, slotType)).tag(new TagKey[]{ItemTags.TRIMMABLE_ARMOR}).model(() -> (ctx, prov) -> Models.generateTrimmedArmor((DataGenContext<Item, Item>)ctx, prov, slotType, TropicraftEquipmentAssets.FIRE));
    }

    private static ItemBuilder<Item, Registrate> scaleArmor(String name, ArmorType slotType) {
        return TropicraftItems.simpleItem(name).properties(p -> TropicraftArmorMaterials.applySafe(p, TropicraftArmorMaterials.SCALE_ARMOR, slotType).component(TropicraftDataComponents.INCOMING_DAMAGE_MODIFIER, (Object)new DamageModifier(List.of(new DamageModifier.Rule(DamageSourcePredicate.Builder.damageType().tag(TagPredicate.is((TagKey)DamageTypeTags.IS_FIRE)).build(), 0.0f))))).tag(new TagKey[]{ItemTags.TRIMMABLE_ARMOR}).model(() -> (ctx, prov) -> Models.generateTrimmedArmor((DataGenContext<Item, Item>)ctx, prov, slotType, TropicraftEquipmentAssets.SCALE));
    }

    private static ItemBuilder<Item, Registrate> scubaGoggles(String name, ScubaType type, Supplier<? extends Item> source) {
        return REGISTRATE.item(name, p -> new Item(TropicraftItems.scubaGoggles(p, type))).clientExtension(() -> ScubaArmorItem.ClientExtensions::new).recipe((ctx, prov) -> ShapedRecipeBuilder.shaped((HolderGetter)prov.itemLookup(), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ctx.get()), (int)1).pattern("YYY").pattern("X X").pattern(" Z ").define(Character.valueOf('X'), (ItemLike)Blocks.GLASS_PANE).define(Character.valueOf('Y'), (ItemLike)ZIRCON.get()).define(Character.valueOf('Z'), (ItemLike)source.get()).unlockedBy("has_" + prov.safeName((ItemLike)source.get()), prov.has((ItemLike)source.get())).unlockedBy("has_" + prov.safeName((ItemLike)ZIRCON.get()), prov.has((ItemLike)ZIRCON.get())).save((RecipeOutput)prov));
    }

    private static Item.Properties scubaGoggles(Item.Properties properties, ScubaType scubaType) {
        ArmorType armorType = ArmorType.HELMET;
        ArmorMaterial material = scubaType.material();
        AttributeModifier visibilityBoost = new AttributeModifier(Tropicraft.location("underwater.visibility"), 0.25, AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
        return properties.durability(armorType.getDurability(material.durability())).attributes(material.createAttributes(armorType).withModifierAdded(TropicraftAttributes.UNDERWATER_VISIBILITY, visibilityBoost, EquipmentSlotGroup.HEAD)).component(DataComponents.EQUIPPABLE, (Object)Equippable.builder((EquipmentSlot)armorType.getSlot()).setEquipSound(material.equipSound()).setAsset(material.assetId()).setCameraOverlay(Tropicraft.location("gui/goggles")).build()).repairable(material.repairIngredient());
    }

    private static ItemBuilder<ScubaHarnessItem, Registrate> scubaHarness(String name, ScubaType type, Supplier<? extends Item> source) {
        return REGISTRATE.item(name, p -> new ScubaHarnessItem(type, (Item.Properties)p)).properties(p -> p.component(TropicraftDataComponents.SCUBA_AIR, (Object)0)).recipe((ctx, prov) -> ShapedRecipeBuilder.shaped((HolderGetter)prov.itemLookup(), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ctx.get()), (int)1).pattern("Y Y").pattern("YXY").pattern("YZY").define(Character.valueOf('X'), (ItemLike)source.get()).define(Character.valueOf('Y'), Tags.Items.LEATHERS).define(Character.valueOf('Z'), (ItemLike)AZURITE.get()).unlockedBy("has_" + prov.safeName((ItemLike)AZURITE.get()), prov.has((ItemLike)AZURITE.get())).save((RecipeOutput)prov)).clientExtension(() -> ScubaArmorItem.ClientExtensions::new);
    }

    private static ItemBuilder<Item, Registrate> scubaFlippers(String name, ScubaType type, Supplier<? extends Item> source) {
        return TropicraftItems.simpleItem(name).properties(p -> {
            p = TropicraftArmorMaterials.applySafe(p, type.material(), ArmorType.BOOTS);
            return p.component(DataComponents.ATTRIBUTE_MODIFIERS, (Object)type.material().createAttributes(ArmorType.BOOTS).withModifierAdded(NeoForgeMod.SWIM_SPEED, new AttributeModifier(Tropicraft.location("scuba"), 0.25, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL), EquipmentSlotGroup.FEET));
        }).recipe((ctx, prov) -> ShapedRecipeBuilder.shaped((HolderGetter)prov.itemLookup(), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ctx.get()), (int)1).pattern("XX").pattern("YY").pattern("XX").define(Character.valueOf('X'), (ItemLike)source.get()).define(Character.valueOf('Y'), (ItemLike)ZIRCON.get()).unlockedBy("has_" + prov.safeName((ItemLike)source.get()), prov.has((ItemLike)source.get())).unlockedBy("has_" + prov.safeName((ItemLike)ZIRCON.get()), prov.has((ItemLike)ZIRCON.get())).save((RecipeOutput)prov)).clientExtension(() -> ScubaArmorItem.ClientExtensions::new);
    }

    private static ItemEntry<PonyBottleItem> ponyBottle(String name, Block glassPane) {
        return REGISTRATE.item(name, PonyBottleItem::new).properties(p -> p.stacksTo(1).durability(32)).recipe((ctx, prov) -> ShapedRecipeBuilder.shaped((HolderGetter)prov.itemLookup(), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ctx.get()), (int)1).pattern("Y").pattern("X").define(Character.valueOf('X'), (ItemLike)glassPane).define(Character.valueOf('Y'), (ItemLike)Blocks.LEVER).unlockedBy("has_" + prov.safeName((ItemLike)glassPane), prov.has((ItemLike)glassPane)).save((RecipeOutput)prov)).register();
    }

    private static ItemBuilder<Item, Registrate> simpleItem(String name) {
        return REGISTRATE.item(name, Item::new);
    }

    private static ItemBuilder<Item, Registrate> food(String name, FoodProperties food) {
        return TropicraftItems.food(name, food, Consumables.DEFAULT_FOOD);
    }

    private static ItemBuilder<Item, Registrate> food(String name, FoodProperties food, Consumable consumable) {
        return TropicraftItems.simpleItem(name).properties(p -> p.food(food, consumable));
    }

    private static ItemBuilder<SignItem, Registrate> sign(WoodType woodType, Supplier<? extends Block> planks, Supplier<? extends StandingSignBlock> standingSign, Supplier<? extends WallSignBlock> wallSign) {
        String woodName = ResourceLocation.parse((String)woodType.name()).getPath();
        return REGISTRATE.item(woodName + "_sign", p -> new SignItem((Block)standingSign.get(), (Block)wallSign.get(), p)).properties(p -> p.stacksTo(16).useBlockDescriptionPrefix()).tag(new TagKey[]{ItemTags.SIGNS}).recipe((ctx, prov) -> ShapedRecipeBuilder.shaped((HolderGetter)prov.itemLookup(), (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ctx.get())).pattern("###").pattern("###").pattern(" | ").define(Character.valueOf('#'), (ItemLike)planks.get()).define(Character.valueOf('|'), Tags.Items.RODS_WOODEN).unlockedBy("has_" + woodName, prov.has((ItemLike)planks.get())).group("wooden_sign").save((RecipeOutput)prov));
    }

    public static void onItemRegister(RegisterEvent event) {
        if (event.getRegistryKey() != Registries.BLOCK) {
            return;
        }
        event.getRegistry().listElements().forEach(holder -> {
            Object patt0$temp = holder.value();
            if (patt0$temp instanceof FlowerPotBlock) {
                FlowerPotBlock flowerPot = (FlowerPotBlock)patt0$temp;
                FlowerPotBlock emptyPot = flowerPot.getEmptyPot();
                Block content = flowerPot.getPotted();
                if (emptyPot.builtInRegistryHolder().is(TropicraftBlocks.BAMBOO_FLOWER_POT.getId()) && emptyPot != flowerPot) {
                    TropicraftItems.addPlant((FlowerPotBlock)TropicraftBlocks.BAMBOO_FLOWER_POT.get(), flowerPot);
                } else if (content.builtInRegistryHolder().key().location().getNamespace().equals("tropicraft")) {
                    TropicraftItems.addPlant((FlowerPotBlock)Blocks.FLOWER_POT, flowerPot);
                }
            }
        });
    }

    private static void addPlant(FlowerPotBlock empty, FlowerPotBlock full) {
        empty.addPlant(full.getPotted().builtInRegistryHolder().key().location(), () -> full);
    }

    private static DataIngredient ingredient(NonNullSupplier<? extends ItemLike> item) {
        return DataIngredient.items(item, (NonNullSupplier[])new NonNullSupplier[0]);
    }

    static {
        REGISTRATE.addDataGenerator((GeneratorType)ProviderType.ITEM_TAGS, prov -> {
            prov.tag(Tags.Items.GEMS).addTags(new TagKey[]{TropicraftTags.Items.AZURITE_GEM, TropicraftTags.Items.EUDIALYTE_GEM, TropicraftTags.Items.ZIRCON_GEM, TropicraftTags.Items.ZIRCONIUM_GEM});
            prov.tag(Tags.Items.INGOTS).addTags(new TagKey[]{TropicraftTags.Items.MANGANESE_INGOT, TropicraftTags.Items.SHAKA_INGOT});
            prov.tag(TropicraftTags.Items.FRUITS).add((Object)Items.APPLE);
            prov.tag(TropicraftTags.Items.MEATS).add((Object[])new Item[]{Items.BEEF, Items.PORKCHOP, Items.CHICKEN, Items.RABBIT, Items.MUTTON});
            prov.tag(TropicraftTags.Items.BAMBOO_TOOL_MATERIALS).add((Object)Items.BAMBOO);
        });
        AZURITE = TropicraftItems.simpleItem("azurite_gem").tag(new TagKey[]{TropicraftTags.Items.AZURITE_GEM}).recipe((ctx, prov) -> prov.smeltingAndBlasting(DataIngredient.tag((HolderSet.Named)prov.itemLookup().getOrThrow(TropicraftTags.Items.AZURITE_ORE)), RecipeCategory.MISC, (Supplier)ctx, 0.3f)).register();
        EUDIALYTE = TropicraftItems.simpleItem("eudialyte_gem").tag(new TagKey[]{TropicraftTags.Items.EUDIALYTE_GEM}).recipe((ctx, prov) -> prov.smeltingAndBlasting(DataIngredient.tag((HolderSet.Named)prov.itemLookup().getOrThrow(TropicraftTags.Items.EUDIALYTE_ORE)), RecipeCategory.MISC, (Supplier)ctx, 0.5f)).register();
        ZIRCON = TropicraftItems.simpleItem("zircon_gem").tag(new TagKey[]{TropicraftTags.Items.ZIRCON_GEM}).recipe((ctx, prov) -> prov.smeltingAndBlasting(DataIngredient.tag((HolderSet.Named)prov.itemLookup().getOrThrow(TropicraftTags.Items.ZIRCON_ORE)), RecipeCategory.MISC, (Supplier)ctx, 0.5f)).register();
        SHAKA = TropicraftItems.simpleItem("shaka_ingot").tag(new TagKey[]{TropicraftTags.Items.SHAKA_INGOT}).recipe((ctx, prov) -> prov.smeltingAndBlasting(DataIngredient.tag((HolderSet.Named)prov.itemLookup().getOrThrow(TropicraftTags.Items.SHAKA_ORE)), RecipeCategory.MISC, (Supplier)ctx, 0.5f)).register();
        MANGANESE = TropicraftItems.simpleItem("manganese_ingot").tag(new TagKey[]{TropicraftTags.Items.MANGANESE_INGOT}).recipe((ctx, prov) -> prov.smeltingAndBlasting(DataIngredient.tag((HolderSet.Named)prov.itemLookup().getOrThrow(TropicraftTags.Items.MANGANESE_ORE)), RecipeCategory.MISC, (Supplier)ctx, 0.5f)).register();
        ZIRCONIUM = TropicraftItems.simpleItem("zirconium_gem").tag(new TagKey[]{TropicraftTags.Items.ZIRCONIUM_GEM}).lang("Zirconium").recipe((ctx, prov) -> ShapelessRecipeBuilder.shapeless((HolderGetter)prov.itemLookup(), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ctx.get())).requires((ItemLike)AZURITE.get(), 2).requires((ItemLike)ZIRCON.get(), 2).unlockedBy("has_zircon", prov.has((ItemLike)ZIRCON.get())).unlockedBy("has_azurite", prov.has((ItemLike)AZURITE.get())).save((RecipeOutput)prov)).register();
        UMBRELLAS = (Map)Arrays.stream(DyeColor.values()).collect(Maps.toImmutableEnumMap(Function.identity(), color -> TropicraftItems.furniture("umbrella", TropicraftEntities.UMBRELLA, color).recipe((ctx, prov) -> {
            Item wool = WOOL_BY_DYE.get(color);
            ShapedRecipeBuilder.shaped((HolderGetter)prov.itemLookup(), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ctx.get())).pattern("WWW").pattern(" B ").pattern(" B ").group("tropicraft:umbrellas").define(Character.valueOf('W'), (ItemLike)wool).define(Character.valueOf('B'), (ItemLike)BAMBOO_STICK.get()).unlockedBy("has_" + color.getSerializedName() + "_wool", prov.has((ItemLike)wool)).save((RecipeOutput)prov);
        }).register()));
        CHAIRS = (Map)Arrays.stream(DyeColor.values()).collect(Maps.toImmutableEnumMap(Function.identity(), color -> TropicraftItems.furniture("chair", TropicraftEntities.CHAIR, color).recipe((ctx, prov) -> {
            Item wool = WOOL_BY_DYE.get(color);
            ShapedRecipeBuilder.shaped((HolderGetter)prov.itemLookup(), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ctx.get())).pattern("BWB").pattern("BWB").pattern("BWB").group("tropicraft:chairs").define(Character.valueOf('W'), (ItemLike)wool).define(Character.valueOf('B'), (ItemLike)BAMBOO_STICK.get()).unlockedBy("has_" + color.getSerializedName() + "_wool", prov.has((ItemLike)wool)).save((RecipeOutput)prov);
        }).register()));
        BEACH_FLOATS = (Map)Arrays.stream(DyeColor.values()).collect(Maps.toImmutableEnumMap(Function.identity(), color -> TropicraftItems.furniture("beach_float", TropicraftEntities.BEACH_FLOAT, color).recipe((ctx, prov) -> {
            Item wool = WOOL_BY_DYE.get(color);
            ShapedRecipeBuilder.shaped((HolderGetter)prov.itemLookup(), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ctx.get())).pattern("WWW").pattern("BBB").group("tropicraft:beach_floats").define(Character.valueOf('W'), (ItemLike)wool).define(Character.valueOf('B'), (ItemLike)Blocks.BAMBOO).unlockedBy("has_" + color.getSerializedName() + "_wool", prov.has((ItemLike)wool)).save((RecipeOutput)prov);
        }).register()));
        BAMBOO_STICK = TropicraftItems.simpleItem("bamboo_stick").tag(new TagKey[]{Tags.Items.RODS_WOODEN}).recipe((ctx, prov) -> ShapedRecipeBuilder.shaped((HolderGetter)prov.itemLookup(), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ctx.get())).pattern("X").pattern("X").define(Character.valueOf('X'), (ItemLike)Items.BAMBOO).unlockedBy("has_bamboo", prov.has((ItemLike)Items.BAMBOO)).save((RecipeOutput)prov, ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"stick_from_bamboo_item")))).model(() -> Models::generateHandheld).register();
        BAMBOO_SPEAR = REGISTRATE.item("bamboo_spear", p -> new SpearItem(TropicraftToolMaterials.BAMBOO, 3, -2.4f, (Item.Properties)p)).recipe((ctx, prov) -> ShapedRecipeBuilder.shaped((HolderGetter)prov.itemLookup(), (RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ctx.get())).pattern("X ").pattern(" X").define(Character.valueOf('X'), (ItemLike)BAMBOO_STICK.get()).unlockedBy("has_bamboo_stick", prov.has((ItemLike)BAMBOO_STICK.get())).save((RecipeOutput)prov)).tag(new TagKey[]{ItemTags.TRIDENT_ENCHANTABLE}).model(() -> Models::generateBambooSpear).register();
        SOLONOX_SHELL = TropicraftItems.shell("solonox_shell").register();
        FROX_CONCH = TropicraftItems.shell("frox_conch").register();
        PAB_SHELL = TropicraftItems.shell("pab_shell").register();
        RUBE_NAUTILUS = TropicraftItems.shell("rube_nautilus").register();
        STARFISH = TropicraftItems.shell("starfish").register();
        TURTLE_SHELL = TropicraftItems.shell("turtle_shell").register();
        LOVE_TROPICS_SHELL = ((ItemBuilder)REGISTRATE.item("love_tropics_shell", LoveTropicsShellItem::new).initialProperties(Item.Properties::new).model(() -> Models::generateLoveTropicsShell).addMiscData((GeneratorType)ProviderType.LANG, prov -> {
            prov.add("item.tropicraft.shell.owned.normal", "%s's Shell");
            prov.add("item.tropicraft.shell.owned.with_s", "%s' Shell");
        })).register();
        FAST_FOOD = Consumables.defaultFood().consumeSeconds(0.8f).build();
        LEMON = TropicraftItems.food("lemon", Foods.LEMON, FAST_FOOD).tag(new TagKey[]{TropicraftTags.Items.FRUITS}).register();
        LIME = TropicraftItems.food("lime", Foods.LIME, FAST_FOOD).tag(new TagKey[]{TropicraftTags.Items.FRUITS}).tag(new TagKey[]{TropicraftTags.Items.LIME}).register();
        GRAPEFRUIT = TropicraftItems.food("grapefruit", Foods.GRAPEFRUIT, FAST_FOOD).tag(new TagKey[]{TropicraftTags.Items.FRUITS}).register();
        ORANGE = TropicraftItems.food("orange", Foods.ORANGE, FAST_FOOD).tag(new TagKey[]{TropicraftTags.Items.FRUITS}).register();
        PASSIONFRUIT = TropicraftItems.food("passionfruit", Foods.PASSIONFRUIT, FAST_FOOD).tag(new TagKey[]{TropicraftTags.Items.FRUITS}).register();
        JOCOTE = TropicraftItems.food("jocote", Foods.JOCOTE, FAST_FOOD).tag(new TagKey[]{TropicraftTags.Items.FRUITS}).register();
        PAPAYA = REGISTRATE.item("papaya", p -> new BlockItem((Block)TropicraftBlocks.PAPAYA.get(), p)).properties(p -> p.food(Foods.PAPAYA)).tag(new TagKey[]{TropicraftTags.Items.FRUITS}).register();
        PINEAPPLE_CUBES = TropicraftItems.food("pineapple_cubes", Foods.PINEAPPLE_CUBES, FAST_FOOD).recipe((ctx, prov) -> ShapelessRecipeBuilder.shapeless((HolderGetter)prov.itemLookup(), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ctx.get()), (int)2).requires(TropicraftBlocks.PINEAPPLE).unlockedBy("has_pineapple", prov.has(TropicraftBlocks.PINEAPPLE)).save((RecipeOutput)prov)).register();
        COCONUT_CHUNK = TropicraftItems.food("coconut_chunk", Foods.COCONUT_CHUNK, FAST_FOOD).register();
        RAW_COFFEE_BEAN = REGISTRATE.item("raw_coffee_bean", p -> new BlockItem((Block)TropicraftBlocks.COFFEE_BUSH.get(), p)).recipe((ctx, prov) -> ShapelessRecipeBuilder.shapeless((HolderGetter)prov.itemLookup(), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ctx.get())).requires((ItemLike)COFFEE_BERRY.get()).unlockedBy("has_coffee_bean", prov.has((ItemLike)COFFEE_BERRY.get())).save((RecipeOutput)prov)).register();
        ROASTED_COFFEE_BEAN = TropicraftItems.simpleItem("roasted_coffee_bean").recipe((ctx, prov) -> prov.food(TropicraftItems.ingredient(RAW_COFFEE_BEAN), RecipeCategory.FOOD, (Supplier)ctx, 0.1f)).register();
        COFFEE_BERRY = TropicraftItems.simpleItem("coffee_berry").register();
        BAMBOO_MUG = TropicraftItems.simpleItem("bamboo_mug").recipe((ctx, prov) -> ShapedRecipeBuilder.shaped((HolderGetter)prov.itemLookup(), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ctx.get())).pattern("X X").pattern("X X").pattern("XXX").define(Character.valueOf('X'), (ItemLike)Items.BAMBOO).unlockedBy("has_bamboo", prov.has((ItemLike)Items.BAMBOO)).save((RecipeOutput)prov)).register();
        BAMBOO_BOWL = TropicraftItems.simpleItem("bamboo_bowl").recipe((ctx, prov) -> ShapedRecipeBuilder.shaped((HolderGetter)prov.itemLookup(), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ctx.get())).pattern("X X").pattern(" X ").define(Character.valueOf('X'), (ItemLike)Items.BAMBOO).unlockedBy("has_bamboo", prov.has((ItemLike)Items.BAMBOO)).save((RecipeOutput)prov)).register();
        GREEN_PLANTAIN = TropicraftItems.food("green_plantain", Foods.PLANTAIN).tag(new TagKey[]{TropicraftTags.Items.PLANTAIN}).register();
        YELLOW_PLANTAIN = TropicraftItems.food("yellow_plantain", Foods.PLANTAIN).tag(new TagKey[]{TropicraftTags.Items.PLANTAIN}).register();
        DRIED_PLANTAINS = TropicraftItems.food("dried_plantains", Foods.DRIED_PLANTAINS).recipe((ctx, prov) -> prov.food(DataIngredient.tag((HolderSet.Named)prov.itemLookup().getOrThrow(TropicraftTags.Items.PLANTAIN)), RecipeCategory.FOOD, (Supplier)ctx, 0.1f)).register();
        MOFONGO = REGISTRATE.item("mofongo", p -> new Item(p)).properties(p -> p.food(Foods.MOFONGO).craftRemainder((Item)BAMBOO_BOWL.get()).usingConvertsTo((Item)BAMBOO_BOWL.get())).recipe((ctx, prov) -> ShapelessRecipeBuilder.shapeless((HolderGetter)prov.itemLookup(), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ctx.get())).requires(DRIED_PLANTAINS, 2).requires(BAMBOO_BOWL).requires((ItemLike)Items.COOKED_PORKCHOP).unlockedBy("has_plantains", prov.has(DRIED_PLANTAINS)).save((RecipeOutput)prov)).register();
        COCKTAIL = REGISTRATE.item("cocktail", CocktailItem::new).properties(p -> p.durability(0).stacksTo(1).component(DataComponents.CONSUMABLE, (Object)Consumables.DEFAULT_DRINK).craftRemainder((Item)BAMBOO_MUG.get())).model(() -> Models::generateCocktail).tab(Tropicraft.CREATIVE_TAB, (ctx, modifier) -> {
            HolderLookup.RegistryLookup drinks = modifier.getParameters().holders().lookupOrThrow(TropicraftRegistries.DRINK);
            drinks.listElements().forEach(drink -> {
                ItemStack stack = new ItemStack((ItemLike)ctx.get());
                stack.set(TropicraftDataComponents.COCKTAIL, (Object)Cocktail.ofDrink((Holder<Drink>)drink));
                modifier.accept(stack);
            });
        }).register();
        REGISTRATE.addDataGenerator(ProviderType.RECIPE, prov -> {
            Holder.Reference pinaColada = prov.registries().lookupOrThrow(TropicraftRegistries.DRINK).getOrThrow(TropicraftDrinks.PINA_COLADA);
            ShapelessRecipeBuilder.shapeless((HolderGetter)prov.itemLookup(), (RecipeCategory)RecipeCategory.FOOD, (ItemStack)CocktailItem.makeDrink((Holder<Drink>)pinaColada)).requires((ItemLike)BAMBOO_MUG.get()).requires((ItemLike)COCONUT_CHUNK.get()).requires((ItemLike)PINEAPPLE_CUBES.get()).unlockedBy("has_bamboo_mug", prov.has((ItemLike)BAMBOO_MUG.get())).save((RecipeOutput)prov, Tropicraft.resourceKey(Registries.RECIPE, "pina_colada"));
        });
        WHITE_PEARL = TropicraftItems.simpleItem("white_pearl").register();
        BLACK_PEARL = TropicraftItems.simpleItem("black_pearl").register();
        SCALE = TropicraftItems.simpleItem("scale").tag(new TagKey[]{TropicraftTags.Items.REPAIRS_SCALE_ARMOR}).register();
        NIGEL_STACHE = TropicraftItems.simpleItem("nigel_stache").properties(p -> TropicraftArmorMaterials.applySafe(p, TropicraftArmorMaterials.NIGEL_STACHE, ArmorType.HELMET)).lang("Nigel's Moustache").tag(new TagKey[]{TropicraftTags.Items.REPAIRS_NIGEL_STACHE}).model(() -> Models::generateNigelStache).register();
        COOL_SHADES = REGISTRATE.item("cool_shades", Item::new).properties(p -> p.stacksTo(1).equippable(EquipmentSlot.HEAD)).model(() -> Models::generateCoolShades).register();
        FRESH_MARLIN = TropicraftItems.food("fresh_marlin", Foods.FRESH_MARLIN).register();
        SEARED_MARLIN = TropicraftItems.food("seared_marlin", Foods.SEARED_MARLIN).recipe((ctx, prov) -> prov.food(TropicraftItems.ingredient(FRESH_MARLIN), RecipeCategory.FOOD, (Supplier)ctx, 0.15f)).register();
        RAW_RAY = TropicraftItems.food("raw_ray", Foods.RAW_RAY).register();
        COOKED_RAY = TropicraftItems.food("cooked_ray", Foods.COOKED_RAY).recipe((ctx, prov) -> prov.food(TropicraftItems.ingredient(RAW_RAY), RecipeCategory.FOOD, (Supplier)ctx, 0.15f)).register();
        FROG_LEG = TropicraftItems.food("frog_leg", Foods.RAW_FROG_LEG).register();
        COOKED_FROG_LEG = TropicraftItems.food("cooked_frog_leg", Foods.COOKED_FROG_LEG).recipe((ctx, prov) -> prov.food(TropicraftItems.ingredient(FROG_LEG), RecipeCategory.FOOD, (Supplier)ctx, 0.1f)).register();
        SEA_URCHIN_ROE = TropicraftItems.food("sea_urchin_roe", Foods.SEA_URCHIN_ROE).register();
        TOASTED_NORI = TropicraftItems.food("toasted_nori", Foods.TOASTED_NORI).recipe((ctx, prov) -> prov.food(DataIngredient.items((ItemLike)Items.SEAGRASS, (ItemLike[])new Item[0]), RecipeCategory.FOOD, (Supplier)ctx, 0.1f)).register();
        RAW_FISH = TropicraftItems.food("raw_fish", Foods.RAW_FISH).tag(new TagKey[]{ItemTags.FISHES}).model(() -> (ctx, prov) -> prov.generateFlatItem((Item)ctx.get(), ModelTemplates.FLAT_ITEM, prov.modLoc("item/smolfish"))).register();
        COOKED_FISH = TropicraftItems.food("cooked_fish", Foods.COOKED_FISH).tag(new TagKey[]{ItemTags.FISHES}).recipe((ctx, prov) -> prov.food(TropicraftItems.ingredient(RAW_FISH), RecipeCategory.FOOD, (Supplier)ctx, 0.1f)).model(() -> (ctx, prov) -> prov.generateFlatItem((Item)ctx.get(), ModelTemplates.FLAT_ITEM, prov.modLoc("item/cooked_smolfish"))).register();
        POISON_FROG_SKIN = TropicraftItems.simpleItem("poison_frog_skin").register();
        IGUANA_LEATHER = TropicraftItems.simpleItem("iguana_leather").tag(new TagKey[]{Tags.Items.LEATHERS}).register();
        TROPICAL_FERTILIZER = REGISTRATE.item("tropical_fertilizer", TropicalFertilizerItem::new).recipe((ctx, prov) -> ShapelessRecipeBuilder.shapeless((HolderGetter)prov.itemLookup(), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ctx.get())).requires((ItemLike)TropicraftFlower.MAGIC_MUSHROOM.get()).requires((ItemLike)TropicraftFlower.CROTON.get()).unlockedBy("has_magic_mushroom", prov.has((ItemLike)TropicraftFlower.MAGIC_MUSHROOM.get())).save((RecipeOutput)prov)).register();
        BAMBOO_ITEM_FRAME = REGISTRATE.item("bamboo_item_frame", BambooItemFrameItem::new).recipe((ctx, prov) -> ShapedRecipeBuilder.shaped((HolderGetter)prov.itemLookup(), (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ctx.get()), (int)1).pattern("XXX").pattern("XYX").pattern("XXX").define(Character.valueOf('X'), (ItemLike)Items.BAMBOO).define(Character.valueOf('Y'), (ItemLike)Items.LEATHER).unlockedBy("has_bamboo", prov.has((ItemLike)Items.BAMBOO)).unlockedBy("has_leather", prov.has((ItemLike)Items.LEATHER)).save((RecipeOutput)prov)).register();
        MUSIC_DISC_BURIED_TREASURE = TropicraftItems.musicDisc(TropicraftJukeboxSongs.BURIED_TREASURE).register();
        MUSIC_DISC_EASTERN_ISLES = TropicraftItems.musicDisc(TropicraftJukeboxSongs.EASTERN_ISLES).register();
        MUSIC_DISC_THE_TRIBE = TropicraftItems.musicDisc(TropicraftJukeboxSongs.THE_TRIBE).register();
        MUSIC_DISC_LOW_TIDE = TropicraftItems.musicDisc(TropicraftJukeboxSongs.LOW_TIDE).register();
        MUSIC_DISC_TRADE_WINDS = TropicraftItems.musicDisc(TropicraftJukeboxSongs.TRADE_WINDS).register();
        MUSIC_DISC_SUMMERING = TropicraftItems.musicDisc(TropicraftJukeboxSongs.SUMMERING).register();
        TROPICAL_FISH_BUCKET = TropicraftItems.fishBucket("tropical_fish_bucket", TropicraftEntities.TROPICAL_FISH).register();
        SARDINE_BUCKET = TropicraftItems.fishBucket("sardine_bucket", TropicraftEntities.RIVER_SARDINE).register();
        PIRANHA_BUCKET = TropicraftItems.fishBucket("piranha_bucket", TropicraftEntities.PIRANHA).register();
        KOA_SPAWN_EGG = TropicraftItems.spawnEgg("koa_spawn_egg", TropicraftEntities.KOA).lang("Koa Headband").register();
        TROPICREEPER_SPAWN_EGG = TropicraftItems.spawnEgg("tropicreeper_spawn_egg", TropicraftEntities.TROPICREEPER).lang("TropiCreeper Hat").register();
        IGUANA_SPAWN_EGG = TropicraftItems.spawnEgg("iguana_spawn_egg", TropicraftEntities.IGUANA).register();
        TROPISKELLY_SPAWN_EGG = TropicraftItems.spawnEgg("tropiskelly_spawn_egg", TropicraftEntities.TROPISKELLY).lang("TropiSkelly Skirt").register();
        EIH_SPAWN_EGG = TropicraftItems.spawnEgg("eih_spawn_egg", TropicraftEntities.EIH).lang("Eye of Head").register();
        SEA_TURTLE_SPAWN_EGG = TropicraftItems.spawnEgg("sea_turtle_spawn_egg", TropicraftEntities.SEA_TURTLE).register();
        MARLIN_SPAWN_EGG = TropicraftItems.spawnEgg("marlin_spawn_egg", TropicraftEntities.MARLIN).register();
        FAILGULL_SPAWN_EGG = TropicraftItems.spawnEgg("failgull_spawn_egg", TropicraftEntities.FAILGULL).register();
        DOLPHIN_SPAWN_EGG = TropicraftItems.spawnEgg("dolphin_spawn_egg", TropicraftEntities.DOLPHIN).register();
        SEAHORSE_SPAWN_EGG = TropicraftItems.spawnEgg("seahorse_spawn_egg", TropicraftEntities.SEAHORSE).register();
        TREE_FROG_SPAWN_EGG = TropicraftItems.spawnEgg("tree_frog_spawn_egg", TropicraftEntities.TREE_FROG).register();
        SEA_URCHIN_SPAWN_EGG = TropicraftItems.spawnEgg("sea_urchin_spawn_egg", TropicraftEntities.SEA_URCHIN).register();
        V_MONKEY_SPAWN_EGG = TropicraftItems.spawnEgg("v_monkey_spawn_egg", TropicraftEntities.V_MONKEY).lang("Vervet Monkey Spawn Egg").register();
        PIRANHA_SPAWN_EGG = TropicraftItems.spawnEgg("piranha_spawn_egg", TropicraftEntities.PIRANHA).register();
        SARDINE_SPAWN_EGG = TropicraftItems.spawnEgg("sardine_spawn_egg", TropicraftEntities.RIVER_SARDINE).register();
        TROPICAL_FISH_SPAWN_EGG = TropicraftItems.spawnEgg("tropical_fish_spawn_egg", TropicraftEntities.TROPICAL_FISH).register();
        EAGLE_RAY_SPAWN_EGG = TropicraftItems.spawnEgg("eagle_ray_spawn_egg", TropicraftEntities.EAGLE_RAY).register();
        TROPI_SPIDER_SPAWN_EGG = TropicraftItems.spawnEgg("tropi_spider_spawn_egg", TropicraftEntities.TROPI_SPIDER).register();
        ASHEN_SPAWN_EGG = TropicraftItems.spawnEgg("ashen_spawn_egg", TropicraftEntities.ASHEN).lang("Ashen Ash").register();
        HAMMERHEAD_SPAWN_EGG = TropicraftItems.spawnEgg("hammerhead_spawn_egg", TropicraftEntities.HAMMERHEAD).register();
        COWKTAIL_SPAWN_EGG = TropicraftItems.spawnEgg("cowktail_spawn_egg", TropicraftEntities.COWKTAIL).register();
        MAN_O_WAR_SPAWN_EGG = TropicraftItems.spawnEgg("man_o_war_spawn_egg", TropicraftEntities.MAN_O_WAR).register();
        TROPIBEE_SPAWN_EGG = TropicraftItems.spawnEgg("tropibee_spawn_egg", TropicraftEntities.TROPI_BEE).register();
        TAPIR_SPAWN_EGG = TropicraftItems.spawnEgg("tapir_spawn_egg", TropicraftEntities.TAPIR).register();
        JAGUAR_SPAWN_EGG = TropicraftItems.spawnEgg("jaguar_spawn_egg", TropicraftEntities.JAGUAR).register();
        BROWN_BASILISK_LIZARD_SPAWN_EGG = TropicraftItems.spawnEgg("brown_basilisk_lizard_spawn_egg", TropicraftEntities.BROWN_BASILISK_LIZARD).register();
        GREEN_BASILISK_LIZARD_SPAWN_EGG = TropicraftItems.spawnEgg("green_basilisk_lizard_spawn_egg", TropicraftEntities.GREEN_BASILISK_LIZARD).register();
        HUMMINGBIRD_SPAWN_EGG = TropicraftItems.spawnEgg("hummingbird_spawn_egg", TropicraftEntities.HUMMINGBIRD).register();
        FIDDLER_CRAB_SPAWN_EGG = TropicraftItems.spawnEgg("fiddler_crab_spawn_egg", TropicraftEntities.FIDDLER_CRAB).register();
        SPIDER_MONKEY_SPAWN_EGG = TropicraftItems.spawnEgg("spider_monkey_spawn_egg", TropicraftEntities.SPIDER_MONKEY).register();
        WHITE_LIPPED_PECCARY_SPAWN_EGG = TropicraftItems.spawnEgg("white_lipped_peccary_spawn_egg", TropicraftEntities.WHITE_LIPPED_PECCARY).register();
        CUBERA_SPAWN_EGG = TropicraftItems.spawnEgg("cubera_spawn_egg", TropicraftEntities.CUBERA).register();
        GIBNUT_SPAWN_EGG = TropicraftItems.spawnEgg("gibnut_spawn_egg", TropicraftEntities.GIBNUT).register();
        MANATEE_SPAWN_EGG = TropicraftItems.spawnEgg("manatee_spawn_egg", TropicraftEntities.MANATEE).register();
        SLENDER_HARVEST_MOUSE_SPAWN_EGG = TropicraftItems.spawnEgg("slender_harvest_mouse_spawn_egg", TropicraftEntities.SLENDER_HARVEST_MOUSE).register();
        TOUCAN_SPAWN_EGG = TropicraftItems.spawnEgg("toucan_spawn_egg", TropicraftEntities.TOUCAN).register();
        PAPYRUS_CANARY_SPAWN_EGG = TropicraftItems.spawnEgg("papyrus_canary_spawn_egg", TropicraftEntities.PAPYRUS_CANARY).register();
        PAPYRUS_GONOLEK_SPAWN_EGG = TropicraftItems.spawnEgg("papyrus_gonolek_spawn_egg", TropicraftEntities.PAPYRUS_GONOLEK).register();
        SHOEBILL_STORK_SPAWN_EGG = TropicraftItems.spawnEgg("shoebill_stork_spawn_egg", TropicraftEntities.SHOEBILL_STORK).register();
        WHITE_COLLARED_OLIVEBACK_SPAWN_EGG = TropicraftItems.spawnEgg("white_collared_oliveback_spawn_egg", TropicraftEntities.WHITE_COLLARED_OLIVEBACK).register();
        WHITE_WINGED_WARBLER_SPAWN_EGG = TropicraftItems.spawnEgg("white_winged_warbler_spawn_egg", TropicraftEntities.WHITE_WINGED_WARBLER).register();
        STARFISH_SPAWN_EGG = TropicraftItems.spawnEgg("starfish_spawn_egg", TropicraftEntities.STARFISH).register();
        ASHEN_MASKS = (ImmutableMap)Arrays.stream(AshenMasks.values()).collect(Maps.toImmutableEnumMap(Function.identity(), type -> REGISTRATE.item("ashen_mask_" + type.id(), AshenMaskItem::new).tag(new TagKey[]{TropicraftTags.Items.ASHEN_MASKS}).lang(type.getName()).model(() -> (ctx, prov) -> Models.generateAshenMask((DataGenContext<Item, AshenMaskItem>)ctx, prov, type)).register()));
        DAGGER = TropicraftItems.simpleItem("dagger").properties(p -> DaggerItem.applyProperties(TropicraftToolMaterials.ZIRCON, p.stacksTo(1))).model(() -> Models::generateHandheld).recipe((ctx, prov) -> ShapedRecipeBuilder.shaped((HolderGetter)prov.itemLookup(), (RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ctx.get())).pattern("X").pattern("I").define(Character.valueOf('X'), (ItemLike)TropicraftBlocks.CHUNK.get()).define(Character.valueOf('I'), (ItemLike)BAMBOO_STICK.get()).unlockedBy("has_" + prov.safeName((ItemLike)TropicraftBlocks.CHUNK.get()), prov.has((ItemLike)TropicraftBlocks.CHUNK.get())).unlockedBy("has_bamboo", prov.has((ItemLike)Items.BAMBOO)).save((RecipeOutput)prov)).register();
        BLOW_GUN = REGISTRATE.item("blow_gun", BlowGunItem::new).properties(p -> p.stacksTo(1)).recipe((ctx, prov) -> ShapedRecipeBuilder.shaped((HolderGetter)prov.itemLookup(), (RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ctx.get())).pattern("X  ").pattern(" I ").pattern("  X").define(Character.valueOf('X'), (ItemLike)BAMBOO_STICK.get()).define(Character.valueOf('I'), (ItemLike)ZIRCON.get()).unlockedBy("has_" + prov.safeName((ItemLike)ZIRCON.get()), prov.has((ItemLike)ZIRCON.get())).unlockedBy("has_" + prov.safeName((ItemLike)BAMBOO_STICK.get()), prov.has((ItemLike)BAMBOO_STICK.get())).save((RecipeOutput)prov)).register();
        ZIRCON_HOE = TropicraftItems.hoe("zircon_hoe", TropicraftToolMaterials.ZIRCON, ZIRCON).register();
        ZIRCONIUM_HOE = TropicraftItems.hoe("zirconium_hoe", TropicraftToolMaterials.ZIRCONIUM, ZIRCONIUM).register();
        EUDIALYTE_HOE = TropicraftItems.hoe("eudialyte_hoe", TropicraftToolMaterials.EUDIALYTE, EUDIALYTE).register();
        ZIRCON_AXE = TropicraftItems.axe("zircon_axe", TropicraftToolMaterials.ZIRCON, ZIRCON).register();
        ZIRCONIUM_AXE = TropicraftItems.axe("zirconium_axe", TropicraftToolMaterials.ZIRCONIUM, ZIRCONIUM).register();
        EUDIALYTE_AXE = TropicraftItems.axe("eudialyte_axe", TropicraftToolMaterials.EUDIALYTE, EUDIALYTE).register();
        ZIRCON_PICKAXE = TropicraftItems.pickaxe("zircon_pickaxe", TropicraftToolMaterials.ZIRCON, ZIRCON).register();
        ZIRCONIUM_PICKAXE = TropicraftItems.pickaxe("zirconium_pickaxe", TropicraftToolMaterials.ZIRCONIUM, ZIRCONIUM).register();
        EUDIALYTE_PICKAXE = TropicraftItems.pickaxe("eudialyte_pickaxe", TropicraftToolMaterials.EUDIALYTE, EUDIALYTE).register();
        ZIRCON_SHOVEL = TropicraftItems.shovel("zircon_shovel", TropicraftToolMaterials.ZIRCON, ZIRCON).register();
        ZIRCONIUM_SHOVEL = TropicraftItems.shovel("zirconium_shovel", TropicraftToolMaterials.ZIRCONIUM, ZIRCONIUM).register();
        EUDIALYTE_SHOVEL = TropicraftItems.shovel("eudialyte_shovel", TropicraftToolMaterials.EUDIALYTE, EUDIALYTE).register();
        ZIRCON_SWORD = TropicraftItems.sword("zircon_sword", TropicraftToolMaterials.ZIRCON, ZIRCON).register();
        ZIRCONIUM_SWORD = TropicraftItems.sword("zirconium_sword", TropicraftToolMaterials.ZIRCONIUM, ZIRCONIUM).register();
        EUDIALYTE_SWORD = TropicraftItems.sword("eudialyte_sword", TropicraftToolMaterials.EUDIALYTE, EUDIALYTE).register();
        FIRE_BOOTS = TropicraftItems.fireArmor("fire_boots", ArmorType.BOOTS).register();
        FIRE_LEGGINGS = TropicraftItems.fireArmor("fire_leggings", ArmorType.LEGGINGS).register();
        FIRE_CHESTPLATE = TropicraftItems.fireArmor("fire_chestplate", ArmorType.CHESTPLATE).register();
        FIRE_HELMET = TropicraftItems.fireArmor("fire_helmet", ArmorType.HELMET).register();
        SCALE_BOOTS = TropicraftItems.scaleArmor("scale_boots", ArmorType.BOOTS).recipe((ctx, prov) -> ShapedRecipeBuilder.shaped((HolderGetter)prov.itemLookup(), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ctx.get())).pattern("X X").pattern("X X").define(Character.valueOf('X'), (ItemLike)SCALE.get()).unlockedBy("has_" + prov.safeName((ItemLike)SCALE.get()), prov.has((ItemLike)SCALE.get())).save((RecipeOutput)prov)).register();
        SCALE_LEGGINGS = TropicraftItems.scaleArmor("scale_leggings", ArmorType.LEGGINGS).recipe((ctx, prov) -> ShapedRecipeBuilder.shaped((HolderGetter)prov.itemLookup(), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ctx.get())).pattern("XXX").pattern("X X").pattern("X X").define(Character.valueOf('X'), (ItemLike)SCALE.get()).unlockedBy("has_" + prov.safeName((ItemLike)SCALE.get()), prov.has((ItemLike)SCALE.get())).save((RecipeOutput)prov)).register();
        SCALE_CHESTPLATE = TropicraftItems.scaleArmor("scale_chestplate", ArmorType.CHESTPLATE).recipe((ctx, prov) -> ShapedRecipeBuilder.shaped((HolderGetter)prov.itemLookup(), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ctx.get())).pattern("X X").pattern("XXX").pattern("XXX").define(Character.valueOf('X'), (ItemLike)SCALE.get()).unlockedBy("has_" + prov.safeName((ItemLike)SCALE.get()), prov.has((ItemLike)SCALE.get())).save((RecipeOutput)prov)).register();
        SCALE_HELMET = TropicraftItems.scaleArmor("scale_helmet", ArmorType.HELMET).recipe((ctx, prov) -> ShapedRecipeBuilder.shaped((HolderGetter)prov.itemLookup(), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ctx.get())).pattern("XXX").pattern("X X").define(Character.valueOf('X'), (ItemLike)SCALE.get()).unlockedBy("has_" + prov.safeName((ItemLike)SCALE.get()), prov.has((ItemLike)SCALE.get())).save((RecipeOutput)prov)).register();
        YELLOW_SCUBA_GOGGLES = TropicraftItems.scubaGoggles("yellow_scuba_goggles", ScubaType.YELLOW, () -> Items.YELLOW_DYE).register();
        YELLOW_SCUBA_HARNESS = TropicraftItems.scubaHarness("yellow_scuba_harness", ScubaType.YELLOW, () -> Items.YELLOW_DYE).register();
        YELLOW_SCUBA_FLIPPERS = TropicraftItems.scubaFlippers("yellow_scuba_flippers", ScubaType.YELLOW, () -> Items.YELLOW_DYE).register();
        PINK_SCUBA_GOGGLES = TropicraftItems.scubaGoggles("pink_scuba_goggles", ScubaType.PINK, () -> Items.PINK_DYE).register();
        PINK_SCUBA_HARNESS = TropicraftItems.scubaHarness("pink_scuba_harness", ScubaType.PINK, () -> Items.PINK_DYE).register();
        PINK_SCUBA_FLIPPERS = TropicraftItems.scubaFlippers("pink_scuba_flippers", ScubaType.PINK, () -> Items.PINK_DYE).register();
        YELLOW_PONY_BOTTLE = TropicraftItems.ponyBottle("yellow_pony_bottle", Blocks.YELLOW_STAINED_GLASS_PANE);
        PINK_PONY_BOTTLE = TropicraftItems.ponyBottle("pink_pony_bottle", Blocks.PINK_STAINED_GLASS_PANE);
        WATER_WAND = REGISTRATE.item("water_wand", WaterWandItem::new).properties(p -> p.stacksTo(1).durability(2000)).recipe((ctx, prov) -> ShapedRecipeBuilder.shaped((HolderGetter)prov.itemLookup(), (RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)ctx.get()), (int)1).pattern("  X").pattern(" Y ").pattern("Y  ").define(Character.valueOf('X'), (ItemLike)AZURITE.get()).define(Character.valueOf('Y'), (ItemLike)Items.GOLD_INGOT).unlockedBy("has_" + prov.safeName((ItemLike)AZURITE.get()), prov.has((ItemLike)AZURITE.get())).unlockedBy("has_gold_ingot", prov.has((ItemLike)Items.GOLD_INGOT)).save((RecipeOutput)prov)).register();
        EXPLODING_COCONUT = REGISTRATE.item("exploding_coconut", ExplodingCoconutItem::new).register();
        FISHING_NET = TropicraftItems.simpleItem("fishing_net").properties(p -> p.stacksTo(1)).register();
        PIANGUAS = TropicraftItems.simpleItem("pianguas").register();
        MAHOGANY_SIGN = TropicraftItems.sign(TropicraftWoodTypes.MAHOGANY, TropicraftBlocks.MAHOGANY_PLANKS, TropicraftBlocks.MAHOGANY_SIGN, TropicraftBlocks.MAHOGANY_WALL_SIGN).register();
        PALM_SIGN = TropicraftItems.sign(TropicraftWoodTypes.PALM, TropicraftBlocks.PALM_PLANKS, TropicraftBlocks.PALM_SIGN, TropicraftBlocks.PALM_WALL_SIGN).register();
        BAMBOO_SIGN = TropicraftItems.sign(TropicraftWoodTypes.BAMBOO, TropicraftBlocks.BAMBOO_BUNDLE, TropicraftBlocks.BAMBOO_SIGN, TropicraftBlocks.BAMBOO_WALL_SIGN).register();
        THATCH_SIGN = TropicraftItems.sign(TropicraftWoodTypes.THATCH, TropicraftBlocks.THATCH_BUNDLE, TropicraftBlocks.THATCH_SIGN, TropicraftBlocks.THATCH_WALL_SIGN).register();
        MANGROVE_SIGN = TropicraftItems.sign(TropicraftWoodTypes.MANGROVE, TropicraftBlocks.MANGROVE_PLANKS, TropicraftBlocks.MANGROVE_SIGN, TropicraftBlocks.MANGROVE_WALL_SIGN).register();
    }

    private static class Models {
        public static final ModelTemplate FACE_ITEM_TEMPLATE = ModelTemplates.createItem((String)Tropicraft.location("template_face_item").toString(), (TextureSlot[])new TextureSlot[]{TextureSlot.LAYER0});
        public static final ModelTemplate EQUIPPED_ASHEN_MASK_TEMPLATE = ModelTemplates.createItem((String)Tropicraft.location("equipped_ashen_mask").toString(), (String)"_equipped", (TextureSlot[])new TextureSlot[]{TextureSlot.LAYER0, TextureSlot.BACK});

        private Models() {
        }

        private static <T extends FurnitureEntity> void generateFurniture(DataGenContext<Item, FurnitureItem<T>> ctx, RegistrateItemModelGenerator prov, String baseName, DyeColor color) {
            ResourceLocation model = prov.generateLayeredItem((Item)ctx.get(), prov.modLoc("item/" + baseName), prov.modLoc("item/" + baseName + "_inverted"));
            prov.itemModelOutput.accept((Item)ctx.get(), ItemModelUtils.tintedModel((ResourceLocation)model, (ItemTintSource[])new ItemTintSource[]{ItemModelGenerators.BLANK_LAYER, new Constant(color.getTextColor())}));
        }

        private static void generateBambooSpear(DataGenContext<Item, SpearItem> ctx, RegistrateItemModelGenerator prov) {
            ModelTemplate template = ModelTemplates.createItem((String)Tropicraft.location("spear").toString(), (TextureSlot[])new TextureSlot[]{TextureSlot.LAYER0});
            ModelTemplate throwingTemplate = ModelTemplates.createItem((String)Tropicraft.location("spear_throwing").toString(), (String)"_throwing", (TextureSlot[])new TextureSlot[]{TextureSlot.LAYER0});
            TextureMapping textures = TextureMapping.layer0((Item)((Item)ctx.get()));
            ItemModel.Unbaked normalModel = ItemModelUtils.plainModel((ResourceLocation)prov.createFlatItemModel((Item)ctx.get(), template));
            ItemModel.Unbaked throwingModel = ItemModelUtils.plainModel((ResourceLocation)throwingTemplate.create((Item)ctx.get(), textures, prov.modelOutput));
            prov.itemModelOutput.accept((Item)ctx.get(), ItemModelUtils.conditional((ConditionalItemModelProperty)ItemModelUtils.isUsingItem(), (ItemModel.Unbaked)throwingModel, (ItemModel.Unbaked)normalModel));
        }

        private static void generateLoveTropicsShell(DataGenContext<Item, LoveTropicsShellItem> ctx, RegistrateItemModelGenerator prov) {
            prov.generateItemWithTintedOverlay((Item)ctx.get(), "_inverted", (ItemTintSource)new TropicraftItemTintSources.LoveTropicsShell());
        }

        private static void generateCocktail(DataGenContext<Item, CocktailItem> ctx, RegistrateItemModelGenerator prov) {
            prov.generateItemWithTintedOverlay((Item)ctx.get(), "_contents", (ItemTintSource)new TropicraftItemTintSources.Cocktail());
        }

        private static void generateNigelStache(DataGenContext<Item, Item> ctx, RegistrateItemModelGenerator prov) {
            Models.generateHeadEquippable(ctx, prov, ModelTemplates.FLAT_ITEM.create((Item)ctx.get(), TextureMapping.layer0((Item)((Item)ctx.get())), prov.modelOutput), FACE_ITEM_TEMPLATE.create(ModelLocationUtils.getModelLocation((Item)((Item)ctx.get()), (String)"_equipped"), TextureMapping.layer0((ResourceLocation)TextureMapping.getItemTexture((Item)((Item)ctx.get()), (String)"_equipped")), prov.modelOutput));
        }

        private static void generateCoolShades(DataGenContext<Item, Item> ctx, RegistrateItemModelGenerator prov) {
            Models.generateHeadEquippable(ctx, prov, ModelTemplates.FLAT_ITEM.create((Item)ctx.get(), TextureMapping.layer0((Item)((Item)ctx.get())), prov.modelOutput), ModelLocationUtils.getModelLocation((Item)((Item)ctx.get()), (String)"_equipped"));
        }

        private static void generateHeadEquippable(DataGenContext<Item, Item> ctx, RegistrateItemModelGenerator prov, ResourceLocation model, ResourceLocation equippedModel) {
            prov.itemModelOutput.accept((Item)ctx.get(), ItemModelUtils.select((SelectItemModelProperty)new DisplayContext(), (ItemModel.Unbaked)ItemModelUtils.plainModel((ResourceLocation)model), (SelectItemModel.SwitchCase[])new SelectItemModel.SwitchCase[]{ItemModelUtils.when(List.of(ItemDisplayContext.HEAD), (ItemModel.Unbaked)ItemModelUtils.plainModel((ResourceLocation)equippedModel))}));
        }

        private static void generateAshenMask(DataGenContext<Item, AshenMaskItem> ctx, RegistrateItemModelGenerator prov, AshenMasks type) {
            ResourceLocation equippedTexture = prov.modLoc("item/ashen_mask/equipped/" + type.id());
            TextureMapping equippedTextures = TextureMapping.layer0((ResourceLocation)equippedTexture).put(TextureSlot.BACK, equippedTexture.withSuffix("_back"));
            ItemModel.Unbaked model = ItemModelUtils.plainModel((ResourceLocation)ModelTemplates.FLAT_ITEM.create((Item)ctx.get(), TextureMapping.layer0((Item)((Item)ctx.get())), prov.modelOutput));
            ItemModel.Unbaked equippedModel = ItemModelUtils.plainModel((ResourceLocation)EQUIPPED_ASHEN_MASK_TEMPLATE.create((Item)ctx.get(), equippedTextures, prov.modelOutput));
            prov.itemModelOutput.accept((Item)ctx.get(), ItemModelUtils.select((SelectItemModelProperty)new DisplayContext(), (ItemModel.Unbaked)model, (SelectItemModel.SwitchCase[])new SelectItemModel.SwitchCase[]{ItemModelUtils.when(List.of(ItemDisplayContext.HEAD), (ItemModel.Unbaked)equippedModel)}));
        }

        private static void generateTrimmedArmor(DataGenContext<Item, Item> ctx, RegistrateItemModelGenerator prov, ArmorType slotType, ResourceKey<EquipmentAsset> asset) {
            ResourceLocation prefix = ItemModelGenerators.prefixForSlotTrim((String)slotType.getSerializedName());
            prov.generateTrimmableItem((Item)ctx.get(), asset, prefix, false);
        }

        private static void generateHandheld(DataGenContext<Item, Item> ctx, RegistrateItemModelGenerator prov) {
            prov.generateFlatItem((Item)ctx.get(), ModelTemplates.FLAT_HANDHELD_ITEM);
        }
    }
}

