/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.item;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;

public class WaterWandItem
extends Item {
    public WaterWandItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult use(Level world, Player player, InteractionHand hand) {
        double inc = 0.2617993877991494;
        ItemStack itemstack = player.getItemInHand(hand);
        EquipmentSlot slot = LivingEntity.getSlotForHand((InteractionHand)hand);
        player.swing(hand);
        if (!world.isClientSide) {
            for (double lat = 0.0; lat < Math.PI * 2; lat += inc) {
                block1: for (double lng = 0.0; lng < Math.PI * 2; lng += inc) {
                    for (double len = 1.0; len < 3.0; len += 0.5) {
                        int x1 = (int)(Math.cos(lat) * len);
                        int z1 = (int)(Math.sin(lat) * len);
                        int y1 = (int)(Math.sin(lng) * len);
                        if (!this.removeWater(world, itemstack, player, new BlockPos((Vec3i)player.blockPosition().offset(x1, y1, z1)), slot)) continue block1;
                    }
                }
            }
        }
        return InteractionResult.PASS;
    }

    private boolean removeWater(Level world, ItemStack itemstack, Player player, BlockPos pos, EquipmentSlot slot) {
        if (!world.isClientSide) {
            if (world.getFluidState(pos).is(FluidTags.WATER)) {
                itemstack.hurtAndBreak(1, (LivingEntity)player, slot);
                world.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
                return true;
            }
            return world.isEmptyBlock(pos);
        }
        return false;
    }
}

