/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.item.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.advancements.critereon.DamageSourcePredicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.tropicraft.core.common.item.component.TropicraftDataComponents;

@EventBusSubscriber(modid="tropicraft")
public record DamageModifier(List<Rule> rules) {
    public static final Codec<DamageModifier> CODEC = RecordCodecBuilder.create(i -> i.group((App)Rule.CODEC.listOf().fieldOf("rules").forGetter(DamageModifier::rules)).apply((Applicative)i, DamageModifier::new));

    public float apply(ServerLevel level, Vec3 position, DamageSource source, float amount) {
        for (Rule rule : this.rules) {
            if (!rule.predicate.matches(level, position, source)) continue;
            amount *= rule.factor;
        }
        return amount;
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingDamageEvent.Pre event) {
        LivingEntity entity = event.getEntity();
        Level level = entity.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        Vec3 position = entity.position();
        DamageSource damageSource = event.getSource();
        for (EquipmentSlot slot : EquipmentSlot.VALUES) {
            DamageModifier damageModifier = (DamageModifier)entity.getItemBySlot(slot).get(TropicraftDataComponents.INCOMING_DAMAGE_MODIFIER);
            if (damageModifier == null) continue;
            event.setNewDamage(damageModifier.apply(serverLevel, position, damageSource, event.getNewDamage()));
        }
    }

    public record Rule(DamageSourcePredicate predicate, float factor) {
        public static final Codec<Rule> CODEC = RecordCodecBuilder.create(i -> i.group((App)DamageSourcePredicate.CODEC.fieldOf("predicate").forGetter(Rule::predicate), (App)ExtraCodecs.NON_NEGATIVE_FLOAT.fieldOf("factor").forGetter(Rule::factor)).apply((Applicative)i, Rule::new));
    }
}

