/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.item.component;

import com.mojang.serialization.Codec;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Unit;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.tropicraft.core.client.data.TropicraftLangKeys;
import net.tropicraft.core.client.scuba.ScubaHUD;
import net.tropicraft.core.common.drinks.Cocktail;
import net.tropicraft.core.common.drinks.DrinkIngredient;
import net.tropicraft.core.common.item.component.DamageModifier;

@EventBusSubscriber(modid="tropicraft")
public class TropicraftDataComponents {
    public static final DeferredRegister.DataComponents REGISTER = DeferredRegister.createDataComponents((ResourceKey)Registries.DATA_COMPONENT_TYPE, (String)"tropicraft");
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Integer>> SCUBA_AIR = REGISTER.registerComponentType("scuba_air", builder -> builder.persistent(ExtraCodecs.NON_NEGATIVE_INT).networkSynchronized(ByteBufCodecs.VAR_INT));
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Float>> EXPLOSION_RADIUS = REGISTER.registerComponentType("explosion_radius", builder -> builder.persistent(Codec.floatRange((float)0.0f, (float)5.0f)).networkSynchronized(ByteBufCodecs.FLOAT));
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<String>> SHELL_NAME = REGISTER.registerComponentType("shell_name", builder -> builder.persistent(Codec.sizeLimitedString((int)64)).networkSynchronized(ByteBufCodecs.STRING_UTF8));
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Cocktail>> COCKTAIL = REGISTER.registerComponentType("cocktail", builder -> builder.persistent(Cocktail.CODEC).networkSynchronized(Cocktail.STREAM_CODEC));
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Boolean>> DESTROYS_BLOCKS = REGISTER.registerComponentType("destroys_blocks", builder -> builder.persistent((Codec)Codec.BOOL).networkSynchronized(ByteBufCodecs.BOOL));
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<DamageModifier>> INCOMING_DAMAGE_MODIFIER = REGISTER.registerComponentType("incoming_damage_modifier", builder -> builder.persistent(DamageModifier.CODEC));
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<String>> SCIENTIFIC_NAME = REGISTER.registerComponentType("scientific_name", builder -> builder.persistent(Codec.sizeLimitedString((int)128)).networkSynchronized(ByteBufCodecs.stringUtf8((int)128)));
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Unit>> HAS_DESCRIPTION = REGISTER.registerComponentType("has_description", builder -> builder.persistent(Unit.CODEC).networkSynchronized(Unit.STREAM_CODEC));

    @SubscribeEvent
    public static void addToItemTooltip(ItemTooltipEvent event) {
        String scientificName;
        Cocktail cocktail;
        ItemStack itemStack = event.getItemStack();
        Integer airRemaining = (Integer)itemStack.get(SCUBA_AIR);
        if (airRemaining != null) {
            event.getToolTip().add(TropicraftLangKeys.SCUBA_AIR_TIME.format(Component.literal((String)ScubaHUD.formatTime(airRemaining.intValue())).withStyle(ScubaHUD.getAirTimeColor(airRemaining))).copy().withStyle(ChatFormatting.GRAY));
        }
        if ((cocktail = (Cocktail)itemStack.get(COCKTAIL)) != null) {
            cocktail.ingredients().forEach(ingredient -> event.getToolTip().add(((DrinkIngredient)ingredient.value()).getDisplayName()));
        }
        if ((scientificName = (String)itemStack.get(SCIENTIFIC_NAME)) != null) {
            event.getToolTip().add(Component.literal((String)scientificName).withStyle(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.ITALIC}));
        }
        if (itemStack.has(HAS_DESCRIPTION)) {
            event.getToolTip().add(Component.translatable((String)(itemStack.getItem().getDescriptionId() + ".desc")).withStyle(ChatFormatting.GRAY));
        }
    }
}

