/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.item.scuba;

import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.level.Level;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class PonyBottleItem
extends Item {
    private static final int FILL_RATE = 6;

    public PonyBottleItem(Item.Properties properties) {
        super(properties);
    }

    public ItemUseAnimation getUseAnimation(ItemStack stack) {
        return ItemUseAnimation.DRINK;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 32;
    }

    public InteractionResult use(Level world, Player player, InteractionHand hand) {
        if (player.getAirSupply() < player.getMaxAirSupply()) {
            player.startUsingItem(hand);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void onUseTick(Level level, LivingEntity player, ItemStack stack, int count) {
        super.onUseTick(level, player, stack, count);
        int fillAmt = 7;
        if (player.getUseItemRemainingTicks() <= 25 && player.getAirSupply() < player.getMaxAirSupply() - fillAmt) {
            player.setAirSupply(player.getAirSupply() + fillAmt);
            stack.hurtAndBreak(1, player, LivingEntity.getSlotForHand((InteractionHand)player.getUsedItemHand()));
        }
    }

    public boolean canContinueUsing(ItemStack oldStack, ItemStack newStack) {
        return !this.shouldCauseReequipAnimation(oldStack, newStack, false);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return oldStack.getItem() != newStack.getItem();
    }
}

