/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.network.message;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.tropicraft.Tropicraft;
import net.tropicraft.core.common.block.tileentity.DrinkMixerBlockEntity;

public record ClientboundMixerInventoryPacket(BlockPos pos, List<ItemStack> inventory, ItemStack result) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ClientboundMixerInventoryPacket> TYPE = new CustomPacketPayload.Type(Tropicraft.location("mixer_inventory"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ClientboundMixerInventoryPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, ClientboundMixerInventoryPacket::pos, (StreamCodec)ItemStack.STREAM_CODEC.apply(ByteBufCodecs.list()), ClientboundMixerInventoryPacket::inventory, (StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, ClientboundMixerInventoryPacket::result, ClientboundMixerInventoryPacket::new);

    public ClientboundMixerInventoryPacket(DrinkMixerBlockEntity mixer) {
        this(mixer.getBlockPos(), List.copyOf(mixer.getDrinkIngredients()), mixer.result);
    }

    public static void handle(ClientboundMixerInventoryPacket packet, IPayloadContext ctx) {
        BlockEntity blockEntity;
        ClientLevel level = Minecraft.getInstance().level;
        if (level != null && (blockEntity = level.getBlockEntity(packet.pos)) instanceof DrinkMixerBlockEntity) {
            DrinkMixerBlockEntity mixer = (DrinkMixerBlockEntity)blockEntity;
            mixer.setDrinkIngredients(List.copyOf(packet.inventory));
            mixer.result = packet.result;
        }
    }

    public CustomPacketPayload.Type<ClientboundMixerInventoryPacket> type() {
        return TYPE;
    }
}

