/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.network.message;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.tropicraft.Tropicraft;
import net.tropicraft.core.common.block.tileentity.SifterBlockEntity;

public record ClientboundSifterInventoryPacket(BlockPos pos, ItemStack siftItem) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ClientboundSifterInventoryPacket> TYPE = new CustomPacketPayload.Type(Tropicraft.location("sifter_inventory"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ClientboundSifterInventoryPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, ClientboundSifterInventoryPacket::pos, (StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, ClientboundSifterInventoryPacket::siftItem, ClientboundSifterInventoryPacket::new);

    public ClientboundSifterInventoryPacket(SifterBlockEntity sifter) {
        this(sifter.getBlockPos(), sifter.getSiftItem());
    }

    public static void handle(ClientboundSifterInventoryPacket packet, IPayloadContext ctx) {
        BlockEntity blockEntity;
        ClientLevel level = Minecraft.getInstance().level;
        if (level != null && (blockEntity = level.getBlockEntity(packet.pos)) instanceof SifterBlockEntity) {
            SifterBlockEntity sifter = (SifterBlockEntity)blockEntity;
            sifter.setSiftItem(packet.siftItem);
        }
    }

    public CustomPacketPayload.Type<ClientboundSifterInventoryPacket> type() {
        return TYPE;
    }
}

