/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.volcano;

import com.mojang.serialization.Codec;
import net.minecraft.util.ExtraCodecs;

public enum VolcanoState {
    DORMANT(604800),
    SMOKING(600),
    RISING(3000),
    ERUPTING(3000),
    RETREATING(600);

    public static final Codec<VolcanoState> CODEC;
    private final int duration;

    private VolcanoState(int duration) {
        this.duration = duration;
    }

    public static int getTimeBefore(VolcanoState state) {
        return switch (state.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> VolcanoState.RETREATING.duration;
            case 1 -> VolcanoState.DORMANT.duration;
            case 2 -> VolcanoState.SMOKING.duration;
            case 3 -> VolcanoState.RISING.duration;
            case 4 -> VolcanoState.ERUPTING.duration;
        };
    }

    static {
        CODEC = ExtraCodecs.legacyEnum(VolcanoState::valueOf);
    }
}

