/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.mixin.datafix;

import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.DataFixerBuilder;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectSortedMap;
import java.lang.reflect.Field;
import net.minecraft.util.datafix.DataFixers;
import net.tropicraft.core.common.datafix.TropicraftDataFixers;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={DataFixers.class})
public class DataFixersMixin {
    @Unique
    private static final Logger tropicraft$LOGGER = LogUtils.getLogger();

    @Inject(method={"addFixers"}, at={@At(value="RETURN")})
    private static void addFixers(final DataFixerBuilder builder, CallbackInfo ci) {
        Int2ObjectSortedMap schemas;
        try {
            Field schemasField = DataFixerBuilder.class.getDeclaredField("schemas");
            schemasField.setAccessible(true);
            schemas = (Int2ObjectSortedMap)schemasField.get(builder);
        }
        catch (ReflectiveOperationException e) {
            tropicraft$LOGGER.error("Unable to inject Tropicraft data fixers", (Throwable)e);
            return;
        }
        TropicraftDataFixers.injectFixers(new TropicraftDataFixers.Builder(){

            @Override
            public void injectFixer(DataFix fix) {
                builder.addFixer(fix);
            }

            @Override
            public Schema getSchema(int version, int subVersion) {
                return (Schema)schemas.get(DataFixUtils.makeKey((int)version, (int)subVersion));
            }
        });
    }
}

