/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.mixin.worldgen;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.WorldDimensions;
import net.tropicraft.core.common.dimension.TropicraftDimension;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={WorldDimensions.class})
public class WorldDimensionsMixin {
    @Mutable
    @Shadow
    @Final
    private static Set<ResourceKey<LevelStem>> BUILTIN_ORDER;
    @Shadow
    @Final
    @Mutable
    private static int VANILLA_DIMENSION_COUNT;

    @Inject(method={"<clinit>"}, at={@At(value="TAIL")})
    private static void init(CallbackInfo ci) {
        ImmutableSet.Builder order = ImmutableSet.builderWithExpectedSize((int)(BUILTIN_ORDER.size() + 1));
        order.addAll(BUILTIN_ORDER);
        order.add(TropicraftDimension.DIMENSION);
        BUILTIN_ORDER = order.build();
        ++VANILLA_DIMENSION_COUNT;
    }

    @Inject(method={"isVanillaLike"}, at={@At(value="HEAD")}, cancellable=true)
    private static void isDimensionStable(ResourceKey<LevelStem> key, LevelStem levelStem, CallbackInfoReturnable<Boolean> ci) {
        if (key == TropicraftDimension.DIMENSION) {
            ci.setReturnValue((Object)true);
        }
    }
}

