/*
 * Decompiled with CFR 0.152.
 */
package org.lovetropics.peekaboo;

import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.attachment.IAttachmentSerializer;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.jetbrains.annotations.Nullable;
import org.lovetropics.peekaboo.PeekabooDataComponents;
import org.lovetropics.peekaboo.api.Disguise;
import org.lovetropics.peekaboo.api.EntityDisguiseHolder;
import org.lovetropics.peekaboo.api.PeekabooApi;
import org.lovetropics.peekaboo.disguise.DisguiseBehavior;
import org.lovetropics.peekaboo.item.PeekabooItems;
import org.lovetropics.peekaboo.network.DisguiseSynchronizer;

@Mod(value="peekaboo")
public class PeekabooMod {
    public static final String ID = "peekaboo";
    private static final DeferredRegister<CreativeModeTab> TAB_REGISTER = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"peekaboo");
    public static final DeferredHolder<CreativeModeTab, ?> CREATIVE_TAB = TAB_REGISTER.register("peekaboo", () -> CreativeModeTab.builder().icon(() -> PeekabooItems.createDisguise(EntityType.CREEPER)).displayItems(PeekabooItems::fillCreativeTab).title((Component)Component.translatable((String)"creative_tab.peekaboo")).build());
    public static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES = DeferredRegister.create((Registry)NeoForgeRegistries.ATTACHMENT_TYPES, (String)"peekaboo");
    public static final Supplier<AttachmentType<EntityDisguiseHolder>> ATTACHMENT = ATTACHMENT_TYPES.register("disguise", () -> AttachmentType.builder(holder -> new EntityDisguiseHolder((Entity)((LivingEntity)holder))).serialize((IAttachmentSerializer)new IAttachmentSerializer<EntityDisguiseHolder>(){

        public EntityDisguiseHolder read(IAttachmentHolder holder, ValueInput input) {
            EntityDisguiseHolder disguise = new EntityDisguiseHolder((Entity)((LivingEntity)holder));
            disguise.set(input.read("disguise", Disguise.CODEC).orElse(Disguise.NONE));
            return disguise;
        }

        public boolean write(EntityDisguiseHolder attachment, ValueOutput output) {
            output.store("disguise", Disguise.CODEC, (Object)attachment.disguise());
            return true;
        }
    }).build());

    public PeekabooMod(IEventBus modBus) {
        PeekabooDataComponents.REGISTER.register(modBus);
        PeekabooItems.REGISTER.register(modBus);
        TAB_REGISTER.register(modBus);
        ATTACHMENT_TYPES.register(modBus);
        PeekabooApi.registerImpl((PeekabooApi.Impl)new PeekabooApi.Impl(this){

            @Nullable
            public EntityDisguiseHolder getDisguiseHolder(Entity entity) {
                if (entity instanceof LivingEntity) {
                    return (EntityDisguiseHolder)entity.getData(ATTACHMENT);
                }
                return null;
            }

            public void onDisguiseChange(EntityDisguiseHolder holder, Entity entity) {
                if (entity instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)entity;
                    DisguiseBehavior.onDisguiseChange(livingEntity);
                    if (!entity.level().isClientSide()) {
                        DisguiseSynchronizer.broadcastDisguise(livingEntity);
                    }
                }
            }
        });
    }

    public static ResourceLocation location(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)ID, (String)path);
    }
}

