/*
 * Decompiled with CFR 0.152.
 */
package org.lovetropics.peekaboo.client.item;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.math.Axis;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.ref.WeakReference;
import java.time.Duration;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.lovetropics.peekaboo.PeekabooDataComponents;
import org.lovetropics.peekaboo.api.Disguise;
import org.lovetropics.peekaboo.api.TypedEntityData;
import org.lovetropics.peekaboo.client.DisguiseRenderState;

public class MobItemSpecialRenderer
implements SpecialModelRenderer<Argument> {
    private final Minecraft minecraft;
    private final EntityRenderDispatcher entityRenderDispatcher;
    private final EntityInfoCache entityInfoCache;
    @Nullable
    private final ResourceLocation inventorySprite;

    private MobItemSpecialRenderer(Minecraft minecraft, EntitySource entitySource, @Nullable ResourceLocation inventorySprite) {
        this.minecraft = minecraft;
        this.entityRenderDispatcher = minecraft.getEntityRenderDispatcher();
        this.entityInfoCache = new EntityInfoCache(this.entityRenderDispatcher, entitySource);
        this.inventorySprite = inventorySprite;
    }

    private static void addVertex(VertexConsumer consumer, PoseStack.Pose pose, float x, float y, float u, float v, int packedLight, int packedOverlay) {
        consumer.addVertex(pose, x, y, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(u, v).setOverlay(packedOverlay).setLight(packedLight).setNormal(pose, 0.0f, 1.0f, 0.0f);
    }

    private void drawInventorySprite(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        if (this.inventorySprite == null) {
            return;
        }
        ResourceLocation atlas = TextureAtlas.LOCATION_BLOCKS;
        TextureAtlasSprite sprite = (TextureAtlasSprite)this.minecraft.getTextureAtlas(atlas).apply(this.inventorySprite);
        VertexConsumer consumer = bufferSource.getBuffer(RenderType.textSeeThrough((ResourceLocation)atlas));
        PoseStack.Pose pose = poseStack.last();
        MobItemSpecialRenderer.addVertex(consumer, pose, 0.0f, 0.0f, sprite.getU0(), sprite.getV1(), packedLight, packedOverlay);
        MobItemSpecialRenderer.addVertex(consumer, pose, 1.0f, 0.0f, sprite.getU1(), sprite.getV1(), packedLight, packedOverlay);
        MobItemSpecialRenderer.addVertex(consumer, pose, 1.0f, 1.0f, sprite.getU1(), sprite.getV0(), packedLight, packedOverlay);
        MobItemSpecialRenderer.addVertex(consumer, pose, 0.0f, 1.0f, sprite.getU0(), sprite.getV0(), packedLight, packedOverlay);
    }

    public void render(@Nullable Argument argument, ItemDisplayContext displayContext, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, boolean hasFoilType) {
        if (argument != null) {
            this.drawEntity(argument, displayContext, poseStack, bufferSource, packedLight);
        }
        if (displayContext == ItemDisplayContext.GUI) {
            this.drawInventorySprite(poseStack, bufferSource, packedLight, packedOverlay);
        }
    }

    private void drawEntity(Argument argument, ItemDisplayContext displayContext, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        poseStack.pushPose();
        poseStack.translate(0.5f, 0.5f, 0.5f);
        this.applyTransforms(argument, displayContext, poseStack);
        this.entityRenderDispatcher.render(argument.entity.renderState(), 0.0, 0.0, 0.0, poseStack, bufferSource, packedLight);
        poseStack.popPose();
    }

    private void applyTransforms(Argument argument, ItemDisplayContext context, PoseStack poseStack) {
        float scale = this.getScale(argument, context);
        poseStack.scale(scale, scale, scale);
        boolean left = context == ItemDisplayContext.FIRST_PERSON_LEFT_HAND || context == ItemDisplayContext.THIRD_PERSON_LEFT_HAND;
        switch (context) {
            case THIRD_PERSON_LEFT_HAND: 
            case THIRD_PERSON_RIGHT_HAND: {
                poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(left ? 25.0f : -25.0f));
                poseStack.translate(0.0f, -0.2f / scale, 0.0f);
                break;
            }
            case FIRST_PERSON_LEFT_HAND: 
            case FIRST_PERSON_RIGHT_HAND: {
                poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(left ? 45.0f : -45.0f));
                poseStack.translate(0.0f, -0.1f / scale, -argument.entity.width() / 2.0f);
                break;
            }
            case HEAD: {
                poseStack.translate(0.0f, 0.375f / scale, 0.0f);
                poseStack.mulPose((Quaternionfc)Axis.YP.rotation((float)Math.PI));
                break;
            }
            case GUI: {
                poseStack.translate(0.0f, -argument.entity.height() / 2.0f, 0.0f);
                poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(25.0f));
                poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(315.0f));
                break;
            }
            case GROUND: {
                poseStack.translate(0.0f, -0.2f / scale, 0.0f);
                break;
            }
            case FIXED: {
                poseStack.translate(0.0f, -0.2f / scale - argument.entity.height() / 2.0f, 0.0f);
                poseStack.mulPose((Quaternionfc)Axis.YP.rotation((float)Math.PI));
            }
        }
    }

    private float getScale(Argument argument, ItemDisplayContext context) {
        float f = argument.targetSize();
        float targetSize = f * (switch (context) {
            case ItemDisplayContext.THIRD_PERSON_LEFT_HAND, ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, ItemDisplayContext.FIRST_PERSON_LEFT_HAND, ItemDisplayContext.FIRST_PERSON_RIGHT_HAND -> 0.8f;
            case ItemDisplayContext.HEAD -> 1.5f;
            case ItemDisplayContext.GUI, ItemDisplayContext.FIXED -> 0.9f;
            case ItemDisplayContext.GROUND -> 0.5f;
            default -> 1.0f;
        });
        return targetSize / Math.max(argument.entity.approximateSize(), 1.0f);
    }

    public void getExtents(Set<Vector3f> output) {
        output.add(new Vector3f(0.0f, 0.0f, 0.0f));
        output.add(new Vector3f(1.0f, 0.0f, 0.0f));
        output.add(new Vector3f(0.0f, 1.0f, 0.0f));
        output.add(new Vector3f(1.0f, 1.0f, 0.0f));
        output.add(new Vector3f(0.0f, 0.0f, 1.0f));
        output.add(new Vector3f(1.0f, 0.0f, 1.0f));
        output.add(new Vector3f(0.0f, 1.0f, 1.0f));
        output.add(new Vector3f(1.0f, 1.0f, 1.0f));
    }

    @Nullable
    public Argument extractArgument(ItemStack stack) {
        ClientLevel level = this.minecraft.level;
        if (level == null) {
            return null;
        }
        ExtractedEntity info = this.entityInfoCache.get(level, stack);
        if (info == null) {
            return null;
        }
        float targetSize = ((Float)stack.getOrDefault(PeekabooDataComponents.SIZE, (Object)Float.valueOf(1.0f))).floatValue();
        return new Argument(info, targetSize);
    }

    private static class EntityInfoCache {
        private final EntityRenderDispatcher entityRenderDispatcher;
        private final EntitySource entitySource;
        @Nullable
        private WeakReference<ClientLevel> level;
        private final Cache<TypedEntityData, EntityInfo> entities = CacheBuilder.newBuilder().expireAfterAccess(Duration.ofSeconds(10L)).build();

        private EntityInfoCache(EntityRenderDispatcher entityRenderDispatcher, EntitySource entitySource) {
            this.entityRenderDispatcher = entityRenderDispatcher;
            this.entitySource = entitySource;
        }

        @Nullable
        public ExtractedEntity get(ClientLevel level, ItemStack itemStack) {
            EntityInfo entityInfo;
            TypedEntityData type = this.entitySource.get(itemStack);
            if (type == null) {
                return null;
            }
            if (this.level == null || this.level.get() != level) {
                this.entities.invalidateAll();
                this.level = new WeakReference<ClientLevel>(level);
            }
            if ((entityInfo = (EntityInfo)this.entities.getIfPresent((Object)type)) == null) {
                Entity entity = type.createEntity((Level)level);
                entityInfo = new EntityInfo(entity);
                this.entities.put((Object)type, (Object)entityInfo);
            }
            return entityInfo.getOrExtractEntity(this.entityRenderDispatcher);
        }
    }

    public static enum EntitySource implements StringRepresentable
    {
        DISGUISE("disguise", stack -> {
            Disguise disguise = (Disguise)stack.getOrDefault(PeekabooDataComponents.DISGUISE, (Object)Disguise.NONE);
            return disguise.entity().orElse(null);
        }),
        ENTITY("entity", stack -> (TypedEntityData)stack.get(PeekabooDataComponents.ENTITY));

        public static final Codec<EntitySource> CODEC;
        private final String name;
        private final Function<ItemStack, TypedEntityData> extractor;

        private EntitySource(String name, Function<ItemStack, TypedEntityData> extractor) {
            this.name = name;
            this.extractor = extractor;
        }

        @Nullable
        public TypedEntityData get(ItemStack stack) {
            return this.extractor.apply(stack);
        }

        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromEnum(EntitySource::values);
        }
    }

    public record Argument(ExtractedEntity entity, float targetSize) {
    }

    public record ExtractedEntity(EntityRenderState renderState, float width, float height, float approximateSize) {
    }

    public record Unbaked(EntitySource entitySource, Optional<ResourceLocation> inventorySprite) implements SpecialModelRenderer.Unbaked
    {
        public static final MapCodec<Unbaked> MAP_CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)EntitySource.CODEC.fieldOf("entity_source").forGetter(Unbaked::entitySource), (App)ResourceLocation.CODEC.optionalFieldOf("inventory_sprite").forGetter(Unbaked::inventorySprite)).apply((Applicative)i, Unbaked::new));

        public MapCodec<Unbaked> type() {
            return MAP_CODEC;
        }

        public SpecialModelRenderer<?> bake(EntityModelSet modelSet) {
            return new MobItemSpecialRenderer(Minecraft.getInstance(), this.entitySource, this.inventorySprite.orElse(null));
        }
    }

    private static class EntityInfo {
        private static final long EXPIRE_AFTER_MILLIS = 1000L;
        @Nullable
        private final Entity entity;
        @Nullable
        private ExtractedEntity extractedEntity;
        private long extractedAtTime;

        private EntityInfo(@Nullable Entity entity) {
            this.entity = entity;
        }

        private boolean hasExtractionExpired() {
            return Util.getMillis() >= this.extractedAtTime + 1000L;
        }

        @Nullable
        public ExtractedEntity getOrExtractEntity(EntityRenderDispatcher entityRenderDispatcher) {
            if (this.extractedEntity != null && !this.hasExtractionExpired()) {
                return this.extractedEntity;
            }
            if (this.entity == null) {
                return null;
            }
            this.extractedAtTime = Util.getMillis();
            this.extractedEntity = this.extractEntity(entityRenderDispatcher, this.entity);
            return this.extractedEntity;
        }

        private <E extends Entity> ExtractedEntity extractEntity(EntityRenderDispatcher entityRenderDispatcher, E entity) {
            EntityRenderer renderer = entityRenderDispatcher.getRenderer(entity);
            return new ExtractedEntity((EntityRenderState)DisguiseRenderState.createFreshRenderState(renderer, entity, 1.0f), entity.getBbWidth(), entity.getBbHeight(), Math.max(entity.getBbWidth() * 2.0f, entity.getBbHeight()));
        }
    }
}

