/*
 * Decompiled with CFR 0.152.
 */
package org.lovetropics.peekaboo.command;

import com.google.common.collect.Iterables;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ComponentArgument;
import net.minecraft.commands.arguments.CompoundTagArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.commands.synchronization.SuggestionProviders;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import org.lovetropics.peekaboo.api.Disguise;
import org.lovetropics.peekaboo.api.EntityDisguiseHolder;
import org.lovetropics.peekaboo.api.TypedEntityData;

@EventBusSubscriber(modid="peekaboo")
public class DisguiseCommand {
    private static final SimpleCommandExceptionType NOT_LIVING_ENTITY = new SimpleCommandExceptionType((Message)Component.translatable((String)"commands.disguise.not_living_entity"));

    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"disguise").requires((Predicate)Commands.hasPermission((int)2))).then(Commands.literal((String)"as").then(((RequiredArgumentBuilder)Commands.argument((String)"entity", (ArgumentType)ResourceArgument.resource((CommandBuildContext)event.getBuildContext(), (ResourceKey)Registries.ENTITY_TYPE)).suggests(SuggestionProviders.cast((SuggestionProvider)SuggestionProviders.SUMMONABLE_ENTITIES)).executes(context -> DisguiseCommand.disguiseAsEntity((CommandContext<CommandSourceStack>)context, ResourceArgument.getSummonableEntityType((CommandContext)context, (String)"entity"), new CompoundTag()))).then(Commands.argument((String)"nbt", (ArgumentType)CompoundTagArgument.compoundTag()).executes(context -> DisguiseCommand.disguiseAsEntity((CommandContext<CommandSourceStack>)context, ResourceArgument.getSummonableEntityType((CommandContext)context, (String)"entity"), CompoundTagArgument.getCompoundTag((CommandContext)context, (String)"nbt"))))))).then(((LiteralArgumentBuilder)Commands.literal((String)"skin").then(Commands.literal((String)"as").then(Commands.argument((String)"player", (ArgumentType)GameProfileArgument.gameProfile()).executes(context -> DisguiseCommand.disguiseSkin((CommandContext<CommandSourceStack>)context, GameProfileArgument.getGameProfiles((CommandContext)context, (String)"player")))))).then(Commands.literal((String)"clear").executes(DisguiseCommand::clearSkin)))).then(((LiteralArgumentBuilder)Commands.literal((String)"name").then(Commands.literal((String)"as").then(Commands.argument((String)"name", (ArgumentType)ComponentArgument.textComponent((CommandBuildContext)event.getBuildContext())).executes(context -> DisguiseCommand.disguiseName((CommandContext<CommandSourceStack>)context, ComponentArgument.getResolvedComponent((CommandContext)context, (String)"name")))))).then(Commands.literal((String)"clear").executes(DisguiseCommand::clearName)))).then(Commands.literal((String)"scale").then(Commands.argument((String)"scale", (ArgumentType)FloatArgumentType.floatArg((float)0.1f, (float)20.0f)).executes(context -> DisguiseCommand.disguiseScale((CommandContext<CommandSourceStack>)context, FloatArgumentType.getFloat((CommandContext)context, (String)"scale")))))).then(Commands.literal((String)"hideShadow").then(Commands.argument((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(context -> DisguiseCommand.disguiseHideShadow((CommandContext<CommandSourceStack>)context, BoolArgumentType.getBool((CommandContext)context, (String)"value")))))).then(Commands.literal((String)"clear").executes(DisguiseCommand::clearDisguise)));
    }

    private static int disguiseAsEntity(CommandContext<CommandSourceStack> context, Holder.Reference<EntityType<?>> entity, CompoundTag nbt) throws CommandSyntaxException {
        TypedEntityData entityData = new TypedEntityData((EntityType)entity.value(), nbt);
        return DisguiseCommand.updateDisguise(context, disguise -> disguise.withEntity(Optional.of(entityData)));
    }

    private static int disguiseSkin(CommandContext<CommandSourceStack> context, Collection<GameProfile> profiles) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        if (profiles.size() != 1) {
            throw EntityArgument.ERROR_NOT_SINGLE_PLAYER.create();
        }
        GameProfile sourceProfile = (GameProfile)Iterables.getOnlyElement(profiles);
        CompletionStage future = SkullBlockEntity.fetchGameProfile((UUID)sourceProfile.getId()).thenApply(maybeProfile -> new ResolvableProfile(maybeProfile.orElse(sourceProfile)));
        if (((CompletableFuture)future).isDone()) {
            EntityDisguiseHolder.update((Entity)player, arg_0 -> DisguiseCommand.lambda$disguiseSkin$8((CompletableFuture)future, arg_0));
            return 1;
        }
        Disguise temporaryDisguise = EntityDisguiseHolder.update((Entity)player, disguise -> disguise.withSkinProfile(Optional.of(new ResolvableProfile(sourceProfile))));
        ((CompletableFuture)future).thenAcceptAsync(resolvedProfile -> EntityDisguiseHolder.update((Entity)player, replacedDisguise -> {
            if (!Objects.equals(replacedDisguise.skinProfile(), temporaryDisguise.skinProfile())) {
                return replacedDisguise;
            }
            return replacedDisguise.withSkinProfile(Optional.of(resolvedProfile));
        }), (Executor)((CommandSourceStack)context.getSource()).getServer());
        return 1;
    }

    private static int clearSkin(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return DisguiseCommand.updateDisguise(context, d -> d.withSkinProfile(Optional.empty()));
    }

    private static int disguiseName(CommandContext<CommandSourceStack> context, Component name) throws CommandSyntaxException {
        return DisguiseCommand.updateDisguise(context, d -> d.withCustomName(Optional.of(name)));
    }

    private static int clearName(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return DisguiseCommand.updateDisguise(context, d -> d.withCustomName(Optional.empty()));
    }

    private static int disguiseScale(CommandContext<CommandSourceStack> context, float scale) throws CommandSyntaxException {
        return DisguiseCommand.updateDisguise(context, d -> d.withScale(scale));
    }

    private static int disguiseHideShadow(CommandContext<CommandSourceStack> context, boolean hideShadow) throws CommandSyntaxException {
        return DisguiseCommand.updateDisguise(context, d -> d.withHideShadow(hideShadow));
    }

    private static int clearDisguise(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return DisguiseCommand.updateDisguise(context, d -> Disguise.NONE);
    }

    private static int updateDisguise(CommandContext<CommandSourceStack> context, UnaryOperator<Disguise> disguise) throws CommandSyntaxException {
        Entity entity = ((CommandSourceStack)context.getSource()).getEntityOrException();
        if (!(entity instanceof LivingEntity)) {
            throw NOT_LIVING_ENTITY.create();
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        EntityDisguiseHolder.update((Entity)livingEntity, disguise);
        return 1;
    }

    private static /* synthetic */ Disguise lambda$disguiseSkin$8(CompletableFuture future, Disguise disguise) {
        return disguise.withSkinProfile(Optional.of((ResolvableProfile)future.join()));
    }
}

