/*
 * Decompiled with CFR 0.152.
 */
package org.lovetropics.peekaboo.disguise;

import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.WalkAnimationState;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import org.jetbrains.annotations.Contract;
import org.lovetropics.peekaboo.api.Disguise;
import org.lovetropics.peekaboo.api.EntityDisguiseHolder;
import org.lovetropics.peekaboo.duck.ExtendedWalkAnimationState;

@EventBusSubscriber(modid="peekaboo")
public final class DisguiseBehavior {
    @SubscribeEvent
    public static void onSetEntitySize(EntityEvent.Size event) {
        EntityDisguiseHolder disguiseHolder = EntityDisguiseHolder.getOrNull((Entity)event.getEntity());
        if (disguiseHolder == null || disguiseHolder.disguise().isEmpty()) {
            return;
        }
        Entity entity = Objects.requireNonNullElse(disguiseHolder.entity(), event.getEntity());
        float scale = disguiseHolder.disguise().scale();
        Pose pose = event.getPose();
        EntityDimensions disguiseDimensions = entity.getDimensions(pose);
        EntityDimensions actualDimensions = disguiseHolder.disguise().changesSize() ? disguiseDimensions : event.getEntity().getDimensions(pose).withEyeHeight(disguiseDimensions.eyeHeight());
        event.setNewSize(actualDimensions.scale(scale));
    }

    public static void copyWalkAnimation(WalkAnimationState from, WalkAnimationState to) {
        ((ExtendedWalkAnimationState)to).peekaboo$copyFrom(from);
    }

    public static void onDisguiseChange(LivingEntity entity) {
        entity.refreshDimensions();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            player.refreshDisplayName();
        }
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            serverPlayer.refreshTabListName();
        }
    }

    @SubscribeEvent
    public static void onPlayerNameFormat(PlayerEvent.NameFormat event) {
        event.setDisplayname(DisguiseBehavior.updateDisplayName(event.getEntity(), event.getDisplayname()));
    }

    @SubscribeEvent
    public static void onPlayerTabListNameFormat(PlayerEvent.TabListNameFormat event) {
        event.setDisplayName(DisguiseBehavior.updateDisplayName(event.getEntity(), event.getDisplayName()));
    }

    @Nullable
    @Contract(value="_,!null->!null")
    private static Component updateDisplayName(Player player, @Nullable Component name) {
        Disguise disguise = EntityDisguiseHolder.getDisguise((Entity)player);
        return disguise.customName().orElse(name);
    }
}

