/*
 * Decompiled with CFR 0.152.
 */
package org.lovetropics.peekaboo.item;

import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingEquipmentChangeEvent;
import org.lovetropics.peekaboo.PeekabooDataComponents;
import org.lovetropics.peekaboo.api.Disguise;
import org.lovetropics.peekaboo.api.EntityDisguiseHolder;
import org.lovetropics.peekaboo.api.TypedEntityData;

@EventBusSubscriber(modid="peekaboo")
public class DisguiseItem
extends Item {
    public DisguiseItem(Item.Properties properties) {
        super(properties);
    }

    public Component getName(ItemStack stack) {
        Disguise disguise = (Disguise)stack.getOrDefault(PeekabooDataComponents.DISGUISE, (Object)Disguise.NONE);
        if (disguise.entity().isPresent()) {
            return Component.translatable((String)(this.getDescriptionId() + ".entity"), (Object[])new Object[]{((TypedEntityData)disguise.entity().get()).type().getDescription()});
        }
        return super.getName(stack);
    }

    @SubscribeEvent
    public static void onEquipmentChange(LivingEquipmentChangeEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity.level().isClientSide()) {
            return;
        }
        EquipmentSlot slot = event.getSlot();
        Disguise fromDisguise = DisguiseItem.getDisguiseForSlot(event.getFrom(), entity, slot);
        Disguise toDisguise = DisguiseItem.getDisguiseForSlot(event.getTo(), entity, slot);
        if (!toDisguise.equals((Object)fromDisguise)) {
            EntityDisguiseHolder.set((Entity)entity, (Disguise)toDisguise);
        }
    }

    private static Disguise getDisguiseForSlot(ItemStack item, LivingEntity entity, EquipmentSlot slot) {
        if (!item.canEquip(slot, entity)) {
            return Disguise.NONE;
        }
        return (Disguise)item.getOrDefault(PeekabooDataComponents.DISGUISE, (Object)Disguise.NONE);
    }
}

