/*
 * Decompiled with CFR 0.152.
 */
package org.lovetropics.peekaboo.item;

import java.util.function.Function;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.lovetropics.peekaboo.PeekabooDataComponents;
import org.lovetropics.peekaboo.api.Disguise;
import org.lovetropics.peekaboo.api.TypedEntityData;
import org.lovetropics.peekaboo.item.DisguiseItem;
import org.lovetropics.peekaboo.item.SimpleMobItem;

public class PeekabooItems {
    public static final DeferredRegister.Items REGISTER = DeferredRegister.createItems((String)"peekaboo");
    public static final DeferredItem<DisguiseItem> DISGUISE = REGISTER.registerItem("disguise", DisguiseItem::new, new Item.Properties().stacksTo(1).equippable(EquipmentSlot.HEAD));
    public static final DeferredItem<SimpleMobItem> MOB_HAT = REGISTER.registerItem("mob_hat", SimpleMobItem::new, new Item.Properties().stacksTo(1).equippable(EquipmentSlot.HEAD));
    public static final DeferredItem<SimpleMobItem> PLUSHIE = REGISTER.registerItem("plushie", SimpleMobItem::new, new Item.Properties().stacksTo(1));

    public static void fillCreativeTab(CreativeModeTab.ItemDisplayParameters parameters, CreativeModeTab.Output output) {
        PeekabooItems.fillForEntities(parameters, output, PeekabooItems::createDisguise);
        PeekabooItems.fillForEntities(parameters, output, entityType -> {
            ItemStack stack = MOB_HAT.toStack();
            stack.set(PeekabooDataComponents.ENTITY, (Object)new TypedEntityData(entityType));
            return stack;
        });
        PeekabooItems.fillForEntities(parameters, output, entityType -> {
            ItemStack stack = PLUSHIE.toStack();
            stack.set(PeekabooDataComponents.ENTITY, (Object)new TypedEntityData(entityType));
            return stack;
        });
    }

    private static void fillForEntities(CreativeModeTab.ItemDisplayParameters parameters, CreativeModeTab.Output output, Function<EntityType<?>, ItemStack> itemFactory) {
        parameters.holders().lookupOrThrow(Registries.ENTITY_TYPE).listElements().forEach(entity -> {
            if (((EntityType)entity.value()).getCategory() == MobCategory.MISC) {
                return;
            }
            output.accept((ItemStack)itemFactory.apply((EntityType)entity.value()));
        });
    }

    public static ItemStack createDisguise(EntityType<?> entity) {
        ItemStack stack = DISGUISE.toStack();
        stack.set(PeekabooDataComponents.DISGUISE, (Object)Disguise.of(entity));
        return stack;
    }
}

