/*
 * Decompiled with CFR 0.152.
 */
package org.lovetropics.peekaboo.mixin;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.WalkAnimationState;
import net.minecraft.world.level.Level;
import org.lovetropics.peekaboo.api.EntityDisguiseHolder;
import org.lovetropics.peekaboo.disguise.DisguiseBehavior;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity {
    @Shadow
    @Final
    public WalkAnimationState walkAnimation;

    private LivingEntityMixin(EntityType<?> type, Level level) {
        super(type, level);
    }

    @Inject(method={"calculateEntityAnimation"}, at={@At(value="HEAD")}, cancellable=true)
    private void calculateEntityAnimation(boolean includeHeight, CallbackInfo ci) {
        Entity entity;
        EntityDisguiseHolder disguise = EntityDisguiseHolder.getOrNull((Entity)this);
        if (disguise != null && (entity = disguise.entity()) instanceof LivingEntity) {
            LivingEntity disguiseEntity = (LivingEntity)entity;
            disguiseEntity.calculateEntityAnimation(includeHeight);
            DisguiseBehavior.copyWalkAnimation(disguiseEntity.walkAnimation, this.walkAnimation);
            ci.cancel();
        }
    }
}

