/*
 * Decompiled with CFR 0.152.
 */
package org.lovetropics.peekaboo.mixin.client;

import com.mojang.authlib.GameProfile;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.Level;
import org.lovetropics.peekaboo.api.Disguise;
import org.lovetropics.peekaboo.api.EntityDisguiseHolder;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractClientPlayer.class})
public abstract class AbstractClientPlayerMixin
extends Player {
    public AbstractClientPlayerMixin(Level level, GameProfile gameProfile) {
        super(level, gameProfile);
    }

    @Inject(method={"getSkin"}, at={@At(value="HEAD")}, cancellable=true)
    private void getSkin(CallbackInfoReturnable<PlayerSkin> cir) {
        Disguise disguise = EntityDisguiseHolder.getDisguise((Entity)this);
        Optional skinProfile = disguise.skinProfile();
        if (skinProfile.isPresent()) {
            SkinManager skinManager = Minecraft.getInstance().getSkinManager();
            cir.setReturnValue((Object)skinManager.getInsecureSkin(((ResolvableProfile)skinProfile.get()).gameProfile()));
        }
    }
}

