/*
 * Decompiled with CFR 0.152.
 */
package org.lovetropics.peekaboo.network;

import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.lovetropics.peekaboo.api.EntityDisguiseHolder;
import org.lovetropics.peekaboo.network.ClientboundSetDisguisePacket;

@EventBusSubscriber(modid="peekaboo")
public class DisguiseSynchronizer {
    @SubscribeEvent
    public static void onEntityTrack(PlayerEvent.StartTracking event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            DisguiseSynchronizer.sendInitialDisguise(player2, event.getTarget());
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            DisguiseSynchronizer.sendInitialDisguise(player2, (Entity)player2);
        }
    }

    @SubscribeEvent
    public static void onPlayerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            DisguiseSynchronizer.sendInitialDisguise(player2, (Entity)player2);
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer newPlayer = (ServerPlayer)player;
            DisguiseSynchronizer.sendInitialDisguise(newPlayer, (Entity)newPlayer);
        }
    }

    private static void sendInitialDisguise(ServerPlayer player, Entity tracked) {
        EntityDisguiseHolder disguiseHolder = EntityDisguiseHolder.getOrNull((Entity)tracked);
        if (disguiseHolder != null && !disguiseHolder.disguise().isEmpty()) {
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new ClientboundSetDisguisePacket(tracked.getId(), disguiseHolder.disguise()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static void broadcastDisguise(LivingEntity entity) {
        EntityDisguiseHolder disguiseHolder = EntityDisguiseHolder.getOrNull((Entity)entity);
        if (disguiseHolder != null) {
            PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)entity, (CustomPacketPayload)new ClientboundSetDisguisePacket(entity.getId(), disguiseHolder.disguise()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }
}

