/*
 * Decompiled with CFR 0.152.
 */
package org.lovetropics.multimedia;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import org.lovetropics.multimedia.DecoderException;
import org.lovetropics.multimedia.Platform;

public class MultimediaNative {
    public static final int PACKET_VIDEO = 0;
    public static final int PACKET_AUDIO = 1;
    public static final int AUDIO_FORMAT_U8 = 0;
    public static final int AUDIO_FORMAT_I16 = 1;
    public static final int AUDIO_FORMAT_I32 = 2;
    public static final int AUDIO_FORMAT_I64 = 3;
    public static final int AUDIO_FORMAT_F32 = 4;
    public static final int AUDIO_FORMAT_F64 = 5;

    public static native long openPathReader(String var0) throws IOException;

    public static native long openByteChannelReader(ReadableByteChannel var0) throws IOException;

    public static native long openSeekableByteChannelReader(SeekableByteChannel var0) throws IOException;

    public static native void destroyReader(long var0) throws IOException;

    public static native double getDuration(long var0);

    public static native long readPacket(long var0) throws IOException;

    public static native void destroyPacket(long var0);

    public static native int getPacketType(long var0);

    public static native void seekTo(long var0, double var2) throws IOException;

    public static native long openVideoDecoder(long var0) throws IOException, DecoderException;

    public static native void destroyVideoDecoder(long var0);

    public static native int getVideoWidth(long var0);

    public static native int getVideoHeight(long var0);

    public static native void sendVideoPacket(long var0, long var2) throws DecoderException;

    public static native long readVideoFrame(long var0) throws DecoderException;

    public static native double getVideoFramePresentTime(long var0);

    public static native double getVideoFramePresentEndTime(long var0);

    public static native void unpackVideoPixels(long var0, int var2, int var3, ByteBuffer var4, int var5) throws DecoderException;

    public static native void destroyVideoFrame(long var0);

    public static native long openAudioDecoder(long var0, int var2, boolean var3, int var4) throws IOException, DecoderException;

    public static native void destroyAudioDecoder(long var0);

    public static native void sendAudioPacket(long var0, long var2) throws DecoderException;

    public static native long readAudioFrame(long var0) throws DecoderException;

    public static native double getAudioFramePresentTime(long var0);

    public static native int getAudioFrameSamples(long var0);

    public static native int getAudioFrameBytes(long var0);

    public static native void unpackAudioSamples(long var0, ByteBuffer var2, int var3) throws DecoderException;

    public static native void destroyAudioFrame(long var0);

    static {
        Loader.load("multimedia");
    }

    private static class Loader {
        private static final Path UNPACK_ROOT = Loader.prepareUnpackRoot();

        private Loader() {
        }

        private static Path prepareUnpackRoot() {
            Path path = Path.of(System.getProperty("java.io.tmpdir"), new String[0]).resolve("lt-multimedia-natives");
            if (Files.exists(path, new LinkOption[0])) {
                try {
                    Files.walkFileTree(path, Set.of(), 1, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                            Files.delete(file);
                            return FileVisitResult.CONTINUE;
                        }
                    });
                }
                catch (IOException iOException) {}
            } else {
                try {
                    Files.createDirectory(path, new FileAttribute[0]);
                }
                catch (IOException e) {
                    throw new LinkageError("Could not create directory for native unpacking", e);
                }
            }
            return path;
        }

        public static void load(String libraryName) {
            Path path = Loader.unpackLibrary(UNPACK_ROOT, libraryName, Platform.detect());
            System.load(path.toAbsolutePath().toString());
            try {
                Files.deleteIfExists(path);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private static Path unpackLibrary(Path root, String libraryName, Platform platform) {
            Path path;
            block9: {
                String libraryPath = platform.getLibraryPath(libraryName);
                InputStream input = Loader.class.getClassLoader().getResourceAsStream(libraryPath);
                try {
                    if (input == null) {
                        throw new LinkageError("Missing native library at " + libraryPath + " for platform " + platform.classifier);
                    }
                    Path path2 = Files.createTempFile(root, libraryName, null, new FileAttribute[0]);
                    Files.copy(input, path2, StandardCopyOption.REPLACE_EXISTING);
                    path = path2;
                    if (input == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (input != null) {
                            try {
                                input.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new LinkageError("Unable to load native library at " + libraryPath, e);
                    }
                }
                input.close();
            }
            return path;
        }
    }
}

