/*
 * Decompiled with CFR 0.152.
 */
package org.lovetropics.multimedia;

import java.util.Locale;
import org.jspecify.annotations.Nullable;

enum Platform {
    WINDOWS("windows", Os.WINDOWS, Arch.X64),
    WINDOWS_ARM64("windows-arm64", Os.WINDOWS, Arch.ARM64),
    MACOS("macos", Os.MACOS, Arch.X64),
    MACOS_ARM64("macos-arm64", Os.MACOS, Arch.ARM64),
    LINUX("linux", Os.LINUX, Arch.X64),
    LINUX_ARM64("linux-arm64", Os.LINUX, Arch.ARM64);

    private static final String OS_NAME;
    private static final String OS_ARCH;
    public final String classifier;
    private final Os os;
    private final Arch arch;

    private Platform(String classifier, Os os, Arch arch) {
        this.classifier = classifier;
        this.os = os;
        this.arch = arch;
    }

    public static Platform detect() {
        Platform platform = Platform.tryDetect();
        if (platform == null) {
            throw new LinkageError("Unrecognized platform: " + OS_NAME + ", " + OS_ARCH);
        }
        return platform;
    }

    public static @Nullable Platform tryDetect() {
        Os os = Os.detect();
        Arch arch = Arch.detect();
        for (Platform platform : Platform.values()) {
            if (platform.os != os || platform.arch != arch) continue;
            return platform;
        }
        return null;
    }

    public String getLibraryPath(String name) {
        return this.os.libraryPrefix + name + "-" + this.classifier + this.os.libraryExtension;
    }

    static {
        OS_NAME = System.getProperty("os.name");
        OS_ARCH = System.getProperty("os.arch");
    }

    public static enum Os {
        WINDOWS("", ".dll"),
        MACOS("lib", ".dylib"),
        LINUX("lib", ".so");

        private final String libraryPrefix;
        private final String libraryExtension;

        private Os(String libraryPrefix, String libraryExtension) {
            this.libraryPrefix = libraryPrefix;
            this.libraryExtension = libraryExtension;
        }

        public static @Nullable Os detect() {
            String osName = OS_NAME.toLowerCase(Locale.ROOT);
            if (osName.contains("win")) {
                return WINDOWS;
            }
            if (osName.contains("mac") || osName.contains("darwin")) {
                return MACOS;
            }
            if (osName.contains("linux") || osName.contains("unix")) {
                return LINUX;
            }
            return null;
        }
    }

    public static enum Arch {
        X86,
        X64,
        ARM64;


        public static @Nullable Arch detect() {
            String archName = OS_ARCH.toLowerCase(Locale.ROOT);
            if (archName.contains("arm64") || archName.equals("aarch64")) {
                return ARM64;
            }
            if (archName.contains("64")) {
                return X64;
            }
            if (archName.contains("86")) {
                return X86;
            }
            return null;
        }
    }
}

