/*
 * Decompiled with CFR 0.152.
 */
package org.lovetropics.multimedia.mod;

import com.google.common.collect.ImmutableSet;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.DecoderException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import java.util.Set;
import net.minecraft.Util;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.neoforged.fml.loading.FMLEnvironment;

public record MediaFile(URI uri) {
    public static final boolean CAN_PLAY_FROM_LOCAL_FILE = !FMLEnvironment.production;
    private static final Set<String> ALLOWED_SCHEMES = (Set)Util.make(() -> {
        ImmutableSet.Builder schemes = ImmutableSet.builder();
        schemes.add((Object)"https");
        if (CAN_PLAY_FROM_LOCAL_FILE) {
            schemes.add((Object)"file");
        }
        return schemes.build();
    });
    public static final Codec<URI> URI_CODEC = Codec.STRING.comapFlatMap(string -> {
        try {
            return DataResult.success((Object)MediaFile.parseAndValidateUri(string));
        }
        catch (URISyntaxException e) {
            return DataResult.error(e::getMessage);
        }
    }, URI::toString);
    public static final Codec<MediaFile> CODEC = URI_CODEC.xmap(MediaFile::new, MediaFile::uri);
    public static final StreamCodec<ByteBuf, MediaFile> STREAM_CODEC = ByteBufCodecs.stringUtf8((int)512).map(string -> {
        try {
            return new MediaFile(MediaFile.parseAndValidateUri(string));
        }
        catch (URISyntaxException e) {
            throw new DecoderException((Throwable)e);
        }
    }, file -> file.uri().toString());

    private static URI parseAndValidateUri(String string) throws URISyntaxException {
        URI uri = new URI(string);
        String scheme = uri.getScheme();
        if (scheme == null) {
            throw new URISyntaxException(string, "Missing protocol in URI: " + string);
        }
        if (!ALLOWED_SCHEMES.contains(scheme.toLowerCase(Locale.ROOT))) {
            throw new URISyntaxException(string, "Unsupported protocol in URI: " + string);
        }
        return uri;
    }

    public boolean isLocalFile() {
        return this.uri.getScheme().equals("file");
    }
}

