/*
 * Decompiled with CFR 0.152.
 */
package org.lovetropics.multimedia.mod;

import net.minecraft.Util;
import org.lovetropics.multimedia.mod.client.playback.ClockSyncer;

public class PlaybackClock {
    private static final long TIME_NOT_SET = -1L;
    private static final double SECONDS_TO_NANOS = 1.0E9;
    private volatile long startedAt = -1L;
    private volatile long pausedAt = -1L;

    public synchronized void play() {
        if (this.startedAt == -1L) {
            this.startedAt = Util.getNanos();
        } else if (this.pausedAt != -1L) {
            long elapsedNanos = this.pausedAt - this.startedAt;
            this.startedAt = Util.getNanos() - elapsedNanos;
            this.pausedAt = -1L;
        }
    }

    public synchronized void pause() {
        if (this.pausedAt == -1L) {
            this.pausedAt = this.getCurrentTimestamp();
        }
    }

    public synchronized void setPaused(boolean paused) {
        if (paused) {
            this.pause();
        } else {
            this.play();
        }
    }

    public synchronized void setElapsedTime(double elapsedTime) {
        boolean wasPaused = this.isPaused();
        long currentTimestamp = Util.getNanos();
        this.startedAt = (long)Math.floor((double)currentTimestamp - elapsedTime * 1.0E9);
        if (wasPaused) {
            this.pausedAt = currentTimestamp;
        }
    }

    public synchronized void set(double elapsedTime, boolean paused) {
        this.setElapsedTime(elapsedTime);
        this.setPaused(paused);
    }

    private long getCurrentTimestamp() {
        return this.pausedAt != -1L ? this.pausedAt : Util.getNanos();
    }

    public synchronized double getElapsedTime() {
        if (this.startedAt == -1L) {
            return 0.0;
        }
        return (double)(this.getCurrentTimestamp() - this.startedAt) / 1.0E9;
    }

    public synchronized boolean isPaused() {
        return this.startedAt == -1L || this.pausedAt != -1L;
    }

    public ClockSyncer createSyncer(final boolean authoritative) {
        return new ClockSyncer(){

            @Override
            public boolean requestSyncTo(double elapsedTime) {
                if (authoritative) {
                    PlaybackClock.this.setElapsedTime(elapsedTime);
                    return true;
                }
                return false;
            }

            @Override
            public double getElapsedTime() {
                return PlaybackClock.this.getElapsedTime();
            }

            @Override
            public boolean isPaused() {
                return PlaybackClock.this.isPaused();
            }
        };
    }
}

