/*
 * Decompiled with CFR 0.152.
 */
package org.lovetropics.multimedia.mod.client;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.opengl.GlBuffer;
import com.mojang.blaze3d.opengl.GlConst;
import com.mojang.blaze3d.opengl.GlStateManager;
import com.mojang.blaze3d.opengl.GlTexture;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.textures.GpuTexture;
import net.neoforged.neoforge.client.blaze3d.validation.ValidationGpuTexture;

public class GpuExtensions {
    public static void copyBufferToTexture(GpuBuffer src, GpuTexture dst, int xOffset, int yOffset, int width, int height, NativeImage.Format pixelFormat) {
        if ((src.usage() & 2) == 0) {
            throw new IllegalArgumentException("Buffer must have USAGE_COPY_SRC flag set");
        }
        if ((dst.usage() & 1) == 0) {
            throw new IllegalArgumentException("Texture must have USAGE_COPY_DST flag set");
        }
        GlStateManager._bindTexture((int)GpuExtensions.handle(dst));
        GlStateManager._pixelStore((int)3314, (int)width);
        GlStateManager._pixelStore((int)3316, (int)0);
        GlStateManager._pixelStore((int)3315, (int)0);
        GlStateManager._pixelStore((int)3317, (int)pixelFormat.components());
        GlStateManager._glBindBuffer((int)35052, (int)GpuExtensions.handle(src));
        GlStateManager._texSubImage2D((int)3553, (int)0, (int)xOffset, (int)yOffset, (int)width, (int)height, (int)GlConst.toGl((NativeImage.Format)pixelFormat), (int)5121, (long)0L);
        GlStateManager._glBindBuffer((int)35052, (int)0);
    }

    private static int handle(GpuTexture texture) {
        if (texture instanceof ValidationGpuTexture) {
            ValidationGpuTexture validationGpuTexture = (ValidationGpuTexture)texture;
            return ((GlTexture)validationGpuTexture.getRealTexture()).glId();
        }
        return ((GlTexture)texture).glId();
    }

    private static int handle(GpuBuffer buffer) {
        return ((GlBuffer)buffer).handle;
    }
}

