/*
 * Decompiled with CFR 0.152.
 */
package org.lovetropics.multimedia.mod.client;

import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.world.entity.EntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.network.event.RegisterClientPayloadHandlersEvent;
import net.neoforged.neoforge.common.NeoForge;
import org.lovetropics.multimedia.mod.MediaFile;
import org.lovetropics.multimedia.mod.MultimediaMod;
import org.lovetropics.multimedia.mod.client.cache.MediaFileCache;
import org.lovetropics.multimedia.mod.client.config.MultimediaClientConfig;
import org.lovetropics.multimedia.mod.client.entity.render.ScreenRenderer;
import org.lovetropics.multimedia.mod.client.slideshow.ClientSlideshowManager;
import org.lovetropics.multimedia.mod.network.ClientboundClearSlideshowPacket;
import org.lovetropics.multimedia.mod.network.ClientboundPreloadMediaPacket;
import org.lovetropics.multimedia.mod.network.ClientboundSeekSlideshowPacket;
import org.lovetropics.multimedia.mod.network.ClientboundStartSlideshowPacket;

@Mod(value="multimedia", dist={Dist.CLIENT})
public class MultimediaClientMod {
    @Nullable
    private static MediaFileCache mediaCache;
    @Nullable
    private static ClientSlideshowManager slideshowManager;

    public MultimediaClientMod(IEventBus modBus, ModContainer modContainer) {
        MultimediaClientConfig.register(modContainer);
        mediaCache = new MediaFileCache(FMLPaths.MODSDIR.get().resolve("lovetropics").resolve("media_cache"), "LoveTropics Multimedia / " + String.valueOf(modContainer.getModInfo().getVersion()));
        slideshowManager = new ClientSlideshowManager(mediaCache);
        modBus.addListener(slideshowManager::registerOverlays);
        modBus.addListener(this::registerEntityRenderers);
        modBus.addListener(this::registerClientHandlers);
        NeoForge.EVENT_BUS.register((Object)slideshowManager);
    }

    public static MediaFileCache mediaCache() {
        return Objects.requireNonNull(mediaCache, "Media cache not initialized");
    }

    public static ClientSlideshowManager slideshowManager() {
        return Objects.requireNonNull(slideshowManager, "Slideshow manager not initialized");
    }

    public void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)MultimediaMod.SCREEN.get(), ScreenRenderer::new);
    }

    public void registerClientHandlers(RegisterClientPayloadHandlersEvent event) {
        MediaFileCache mediaCache = MultimediaClientMod.mediaCache();
        ClientSlideshowManager slideshowManager = MultimediaClientMod.slideshowManager();
        event.register(ClientboundPreloadMediaPacket.TYPE, (packet, context) -> {
            for (MediaFile file : packet.files()) {
                mediaCache.ensureDownloaded(file);
            }
        });
        event.register(ClientboundStartSlideshowPacket.TYPE, (packet, context) -> slideshowManager.start(packet.id(), packet.slideshow(), packet.time(), packet.paused()));
        event.register(ClientboundClearSlideshowPacket.TYPE, (packet, context) -> slideshowManager.clear(packet.id()));
        event.register(ClientboundSeekSlideshowPacket.TYPE, (packet, context) -> slideshowManager.seekTo(packet.id(), packet.time(), packet.paused()));
    }
}

