/*
 * Decompiled with CFR 0.152.
 */
package org.lovetropics.multimedia.mod.client;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.FrameGraphSetupEvent;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@EventBusSubscriber(modid="multimedia", value={Dist.CLIENT})
public class ScreenSizeCapture {
    private static final Matrix4f CAPTURED_PROJECTION = new Matrix4f();

    @SubscribeEvent
    public static void onFrameGraphSetup(FrameGraphSetupEvent event) {
        CAPTURED_PROJECTION.set((Matrix4fc)event.getProjectionMatrix());
    }

    @Nullable
    public static Vector2fc sizeInScreenPixels(PoseStack.Pose pose, Vector3fc ... vertices) {
        if (vertices.length == 0) {
            return null;
        }
        Matrix4f modelToNdc = new Matrix4f((Matrix4fc)CAPTURED_PROJECTION).mul((Matrix4fc)RenderSystem.getModelViewMatrix()).mul((Matrix4fc)pose.pose());
        Vector3f minNdc = new Vector3f(Float.MAX_VALUE);
        Vector3f maxNdc = new Vector3f(-3.4028235E38f);
        Vector3f vertexNdc = new Vector3f();
        for (Vector3fc vertex : vertices) {
            modelToNdc.transformProject(vertex, vertexNdc);
            vertexNdc.set(Mth.clamp((float)vertexNdc.x(), (float)-1.0f, (float)1.0f), Mth.clamp((float)vertexNdc.y(), (float)-1.0f, (float)1.0f), vertexNdc.z());
            minNdc.min((Vector3fc)vertexNdc);
            maxNdc.max((Vector3fc)vertexNdc);
        }
        if (maxNdc.z() < 0.0f) {
            return null;
        }
        Window window = Minecraft.getInstance().getWindow();
        return new Vector2f((maxNdc.x - minNdc.x) / 2.0f * (float)window.getWidth(), (maxNdc.y - minNdc.y) / 2.0f * (float)window.getHeight());
    }
}

