/*
 * Decompiled with CFR 0.152.
 */
package org.lovetropics.multimedia.mod.client.cache;

import java.io.IOException;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.annotation.Nullable;
import org.lovetropics.multimedia.mod.client.cache.FileDownload;
import org.lovetropics.multimedia.mod.client.cache.MediaFileId;
import org.lovetropics.multimedia.mod.client.cache.MediaIndex;

class CachedFile {
    private final MediaFileId fileId;
    private final Path path;
    @Nullable
    private final FileDownload download;
    private Instant lastAccessedAt;

    private CachedFile(MediaFileId fileId, Path path, @Nullable FileDownload download, Instant lastAccessedAt) {
        this.fileId = fileId;
        this.path = path;
        this.download = download;
        this.lastAccessedAt = lastAccessedAt;
    }

    public static CachedFile fromDownload(MediaFileId fileId, FileDownload download) {
        return new CachedFile(fileId, download.path(), download, Instant.now());
    }

    @Nullable
    public static CachedFile fromCache(Path rootPath, MediaIndex.CachedFile file) {
        Path path = rootPath.resolve(file.fileName());
        if (!Files.exists(path, new LinkOption[0])) {
            return null;
        }
        return new CachedFile(file.fileId(), path, null, file.lastAccessedAt());
    }

    public MediaFileId fileId() {
        return this.fileId;
    }

    public Path path() {
        return this.path;
    }

    public Duration getTimeSinceLastAccess() {
        return Duration.between(this.lastAccessedAt, Instant.now());
    }

    public void touch() {
        this.lastAccessedAt = Instant.now();
    }

    public CompletionStage<Void> awaitDownload() {
        return this.download != null ? this.download.awaitComplete() : CompletableFuture.completedFuture(null);
    }

    public boolean isDownloaded() {
        return this.download == null || this.download.isComplete();
    }

    public MediaIndex.CachedFile asIndexFile(Path rootPath) {
        return new MediaIndex.CachedFile(this.fileId, rootPath.relativize(this.path).toString(), this.lastAccessedAt);
    }

    public SeekableByteChannel openChannel() throws IOException {
        if (this.download != null) {
            return this.download.openChannel();
        }
        return Files.newByteChannel(this.path, new OpenOption[0]);
    }
}

