/*
 * Decompiled with CFR 0.152.
 */
package org.lovetropics.multimedia.mod.client.cache;

import com.mojang.logging.LogUtils;
import java.io.Closeable;
import java.io.IOException;
import java.net.http.HttpResponse;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.Objects;
import java.util.OptionalLong;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;

class FileDownload
implements AutoCloseable {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final OpenOption[] OPEN_OPTIONS = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE};
    private final Path path;
    private final long size;
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition canRead = this.lock.newCondition();
    private final FileChannel file;
    private long writeIndex;
    private boolean writerOpen = true;
    private int readersOpen;
    private final CompletableFuture<Void> completeFuture = new CompletableFuture();

    private FileDownload(Path path, long size) throws IOException {
        this.path = path;
        this.size = size;
        this.file = FileChannel.open(path, OPEN_OPTIONS);
    }

    public static HttpResponse.BodyHandler<Response> bodyHandler() {
        return responseInfo -> new Response(responseInfo.headers().firstValueAsLong("Content-Length"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFully(ByteBuffer buffer) throws IOException {
        while (buffer.hasRemaining()) {
            this.lock.lock();
            FileChannel file = Objects.requireNonNull(this.file);
            try {
                file.position(this.writeIndex);
                int written = file.write(buffer);
                if (written <= 0) continue;
                this.writeIndex += (long)written;
                this.canRead.signal();
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private void reportError(Throwable throwable) {
        LOGGER.error("An error occurred while downloading file", throwable);
        this.completeFuture.completeExceptionally(throwable);
        this.closeWriter();
    }

    private void reportComplete() {
        this.completeFuture.complete(null);
        this.closeWriter();
    }

    public CompletionStage<Void> awaitComplete() {
        return this.completeFuture;
    }

    public boolean isComplete() {
        return this.completeFuture.state() == Future.State.SUCCESS;
    }

    public Path path() {
        return this.path;
    }

    public long size() {
        return this.size;
    }

    public SeekableByteChannel openChannel() throws IOException {
        this.lock.lock();
        try {
            if (!this.writerOpen) {
                SeekableByteChannel seekableByteChannel = Files.newByteChannel(this.path, new OpenOption[0]);
                return seekableByteChannel;
            }
            ++this.readersOpen;
        }
        finally {
            this.lock.unlock();
        }
        return new SeekableByteChannel(){
            private long readIndex;
            private boolean closed;

            @Override
            public int read(ByteBuffer dst) throws IOException {
                FileDownload.this.lock.lock();
                try {
                    while (this.readIndex < FileDownload.this.size) {
                        int readBytes = this.tryRead(dst);
                        if (readBytes == 0) {
                            if (!FileDownload.this.writerOpen) {
                                int n = -1;
                                return n;
                            }
                        } else {
                            int n = readBytes;
                            return n;
                        }
                        FileDownload.this.canRead.await();
                    }
                }
                catch (InterruptedException e) {
                    this.close();
                    throw new ClosedByInterruptException();
                }
                finally {
                    FileDownload.this.lock.unlock();
                }
                return -1;
            }

            private int tryRead(ByteBuffer dst) throws IOException {
                long availableBytes = FileDownload.this.writeIndex - this.readIndex;
                if (availableBytes <= 0L) {
                    return 0;
                }
                int oldLimit = dst.limit();
                dst.limit((int)Math.min((long)oldLimit, (long)dst.position() + availableBytes));
                FileDownload.this.file.position(this.readIndex);
                int readBytes = FileDownload.this.file.read(dst);
                if (readBytes != -1) {
                    this.readIndex += (long)readBytes;
                }
                dst.limit(oldLimit);
                return readBytes;
            }

            @Override
            public int write(ByteBuffer src) throws IOException {
                throw new IOException("Writing is not supported");
            }

            @Override
            public long position() {
                return this.readIndex;
            }

            @Override
            public SeekableByteChannel position(long newPosition) {
                this.readIndex = newPosition;
                return this;
            }

            @Override
            public long size() {
                return FileDownload.this.size;
            }

            @Override
            public SeekableByteChannel truncate(long size) throws IOException {
                throw new IOException("Truncation is not supported");
            }

            @Override
            public boolean isOpen() {
                return !this.closed;
            }

            @Override
            public void close() {
                if (this.closed) {
                    return;
                }
                this.closed = true;
                FileDownload.this.closeReader();
            }
        };
    }

    private void closeWriter() {
        this.lock.lock();
        try {
            this.writerOpen = false;
            if (this.readersOpen > 0) {
                this.canRead.signal();
            } else {
                this.close();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void closeReader() {
        this.lock.lock();
        try {
            if (--this.readersOpen == 0 && !this.writerOpen) {
                this.close();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void close() {
        this.lock.lock();
        try {
            IOUtils.closeQuietly((Closeable)this.file);
        }
        finally {
            this.lock.unlock();
        }
    }

    static class Response
    implements HttpResponse.BodySubscriber<Response> {
        private final OptionalLong contentLength;
        private final ReentrantLock lock = new ReentrantLock();
        @Nullable
        private volatile FileDownload download;
        @Nullable
        private Flow.Subscription subscription;

        public Response(OptionalLong contentLength) {
            this.contentLength = contentLength;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FileDownload startWritingTo(Path path) throws IOException {
            long contentLength = this.contentLength.orElseThrow(() -> new IOException("Response did not have Content-Length header"));
            FileDownload download = new FileDownload(path, contentLength);
            this.lock.lock();
            try {
                if (this.download != null) {
                    throw new IllegalStateException("Already started download");
                }
                this.download = download;
                if (this.subscription != null) {
                    this.subscription.request(1L);
                }
                FileDownload fileDownload = download;
                return fileDownload;
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public CompletionStage<Response> getBody() {
            return CompletableFuture.completedFuture(this);
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            this.lock.lock();
            try {
                if (this.subscription != null) {
                    subscription.cancel();
                    return;
                }
                this.subscription = subscription;
                if (this.download != null) {
                    subscription.request(1L);
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public void onNext(List<ByteBuffer> item) {
            FileDownload download = this.download;
            if (download == null) {
                return;
            }
            try {
                for (ByteBuffer buffer : item) {
                    download.writeFully(buffer);
                }
                Objects.requireNonNull(this.subscription).request(1L);
            }
            catch (Throwable throwable) {
                download.reportError(throwable);
            }
        }

        @Override
        public void onError(Throwable throwable) {
            FileDownload download = this.download;
            if (download != null) {
                download.reportError(throwable);
            }
        }

        @Override
        public void onComplete() {
            FileDownload download = this.download;
            if (download != null) {
                download.reportComplete();
            }
        }
    }
}

