/*
 * Decompiled with CFR 0.152.
 */
package org.lovetropics.multimedia.mod.client.cache;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.net.URI;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import net.minecraft.util.ExtraCodecs;
import org.lovetropics.multimedia.mod.MediaFile;

record MediaFileId(URI uri, Optional<String> etag, long size, Instant resolvedAt) {
    public static final MapCodec<MediaFileId> MAP_CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)MediaFile.URI_CODEC.fieldOf("uri").forGetter(MediaFileId::uri), (App)Codec.STRING.optionalFieldOf("etag").forGetter(MediaFileId::etag), (App)Codec.LONG.fieldOf("size").forGetter(MediaFileId::size), (App)ExtraCodecs.INSTANT_ISO8601.fieldOf("resolved_at").forGetter(MediaFileId::resolvedAt)).apply((Applicative)i, MediaFileId::new));

    public Duration getCurrentAge() {
        return Duration.between(this.resolvedAt, Instant.now());
    }
}

