/*
 * Decompiled with CFR 0.152.
 */
package org.lovetropics.multimedia.mod.client.cache;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.time.Instant;
import java.util.List;
import net.minecraft.FileUtil;
import net.minecraft.util.ExtraCodecs;
import org.lovetropics.multimedia.mod.client.cache.MediaFileId;
import org.slf4j.Logger;

record MediaIndex(List<CachedFile> cachedFiles) {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final Codec<MediaIndex> CODEC = CachedFile.CODEC.listOf().xmap(MediaIndex::new, MediaIndex::cachedFiles);

    public static MediaIndex load(Path path) {
        MediaIndex mediaIndex;
        block9: {
            if (!Files.exists(path, new LinkOption[0])) {
                return new MediaIndex(List.of());
            }
            BufferedReader reader = Files.newBufferedReader(path, StandardCharsets.UTF_8);
            try {
                mediaIndex = (MediaIndex)CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseReader((Reader)reader)).getPartialOrThrow(JsonSyntaxException::new);
                if (reader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (JsonParseException | IOException e) {
                    LOGGER.error("Failed to load index file", e);
                    return new MediaIndex(List.of());
                }
            }
            reader.close();
        }
        return mediaIndex;
    }

    public void store(Path path) {
        JsonElement json = (JsonElement)CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this).getOrThrow();
        try (BufferedWriter writer = Files.newBufferedWriter(path, StandardCharsets.UTF_8, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            GSON.toJson(json, (Appendable)writer);
        }
        catch (IOException e) {
            LOGGER.error("Failed to store index file", (Throwable)e);
        }
    }

    public record CachedFile(MediaFileId fileId, String fileName, Instant lastAccessedAt) {
        private static final Codec<String> FILE_NAME_CODEC = Codec.STRING.validate(name -> {
            if (name.indexOf(47) != -1 || !FileUtil.isPathPartPortable((String)name)) {
                return DataResult.error(() -> "Invalid file name: " + name);
            }
            return DataResult.success((Object)name);
        });
        public static final Codec<CachedFile> CODEC = RecordCodecBuilder.create(i -> i.group((App)MediaFileId.MAP_CODEC.forGetter(CachedFile::fileId), (App)FILE_NAME_CODEC.fieldOf("file_name").forGetter(CachedFile::fileName), (App)ExtraCodecs.INSTANT_ISO8601.fieldOf("last_accessed_at").forGetter(CachedFile::lastAccessedAt)).apply((Applicative)i, CachedFile::new));
    }
}

