/*
 * Decompiled with CFR 0.152.
 */
package org.lovetropics.multimedia.mod.client.config;

import com.mojang.serialization.Codec;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.Options;
import net.minecraft.client.gui.components.AbstractOptionSliderButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;

public class MultimediaClientConfig {
    private static final MultimediaClientConfig INSTANCE = new MultimediaClientConfig();
    private static final double MAX_VOLUME = 2.0;
    public final ModConfigSpec.DoubleValue audioVolume;
    private final ModConfigSpec spec;

    private MultimediaClientConfig() {
        ModConfigSpec.Builder spec = new ModConfigSpec.Builder();
        this.audioVolume = spec.defineInRange("audioVolume", 1.0, 0.0, 2.0);
        this.spec = spec.build();
    }

    public static MultimediaClientConfig get() {
        return INSTANCE;
    }

    public OptionInstance<Double> audioVolumeOption() {
        return new OptionInstance("soundCategory.multimedia.video", OptionInstance.noTooltip(), MultimediaClientConfig::percentOrOff, (OptionInstance.ValueSet)new OptionInstance.ValueSet<Double>(){

            public Function<OptionInstance<Double>, AbstractWidget> createButton(OptionInstance.TooltipSupplier<Double> tooltipSupplier, Options options, int x, int y, int width, Consumer<Double> onValueChanged) {
                return option -> new VolumeSlider(options, x, y, width, (OptionInstance<Double>)option);
            }

            public Optional<Double> validateValue(Double value) {
                return Optional.of(value);
            }

            public Codec<Double> codec() {
                return Codec.DOUBLE;
            }
        }, (Object)this.audioVolume.getAsDouble(), arg_0 -> ((ModConfigSpec.DoubleValue)this.audioVolume).set(arg_0));
    }

    private static Component percentOrOff(Component text, double value) {
        if (value == 0.0) {
            return Options.genericValueLabel((Component)text, (Component)CommonComponents.OPTION_OFF);
        }
        return Component.translatable((String)"options.percent_value", (Object[])new Object[]{text, Mth.floor((double)(value * 100.0))});
    }

    public static void register(ModContainer modContainer) {
        modContainer.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)MultimediaClientConfig.INSTANCE.spec);
    }

    private class VolumeSlider
    extends AbstractOptionSliderButton {
        private final OptionInstance<Double> option;

        public VolumeSlider(Options options, int x, int y, int width, OptionInstance<Double> option) {
            super(options, x, y, width, 20, (Double)option.get() / 2.0);
            this.option = option;
            this.updateMessage();
        }

        protected void updateMessage() {
            this.setMessage(MultimediaClientConfig.percentOrOff(this.option.caption, this.value * 2.0));
        }

        protected void applyValue() {
            MultimediaClientConfig.this.audioVolume.set((Object)(this.value * 2.0));
        }
    }
}

