/*
 * Decompiled with CFR 0.152.
 */
package org.lovetropics.multimedia.mod.client.entity;

import org.jetbrains.annotations.Nullable;
import org.lovetropics.multimedia.mod.client.cache.MediaFileCache;
import org.lovetropics.multimedia.mod.client.config.MultimediaClientConfig;
import org.lovetropics.multimedia.mod.client.playback.PlaybackSyncType;
import org.lovetropics.multimedia.mod.client.slideshow.SlideshowDriver;
import org.lovetropics.multimedia.mod.client.slideshow.SlideshowRenderState;
import org.lovetropics.multimedia.mod.entity.ScreenEntity;
import org.lovetropics.multimedia.mod.slideshow.Slideshow;

public class ScreenClientState
implements AutoCloseable {
    @Nullable
    private SlideshowDriver driver;

    public void tick(ScreenEntity screen) {
        if (this.driver != null) {
            this.driver.setAudioVolume((float)MultimediaClientConfig.get().audioVolume.getAsDouble());
            this.driver.setAudioSource(screen.asAudioSource());
            this.driver.tick();
        }
    }

    public void start(MediaFileCache mediaCache, Slideshow slideshow, double time, boolean paused) {
        if (this.driver == null || !this.driver.slideshow().equals(slideshow)) {
            if (this.driver != null) {
                this.driver.close();
            }
            this.driver = new SlideshowDriver(mediaCache, slideshow, PlaybackSyncType.WALL_TIME);
        }
        this.driver.seekTo(time, paused);
    }

    public void clear() {
        if (this.driver != null) {
            this.driver.close();
            this.driver = null;
        }
    }

    public void seekTo(double time, boolean paused) {
        if (this.driver != null) {
            this.driver.seekTo(time, paused);
        }
    }

    @Nullable
    public SlideshowRenderState extractRenderState(float partialTicks) {
        return this.driver != null ? this.driver.extractRenderState(partialTicks) : null;
    }

    @Override
    public void close() {
        this.clear();
    }
}

