/*
 * Decompiled with CFR 0.152.
 */
package org.lovetropics.multimedia.mod.client.entity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.world.entity.Entity;
import org.joml.Quaternionfc;
import org.lovetropics.multimedia.mod.client.MultimediaClientMod;
import org.lovetropics.multimedia.mod.client.entity.ScreenClientState;
import org.lovetropics.multimedia.mod.client.entity.render.ScreenRenderState;
import org.lovetropics.multimedia.mod.client.slideshow.ClientSlideshowManager;
import org.lovetropics.multimedia.mod.client.slideshow.SlideshowGraphics;
import org.lovetropics.multimedia.mod.entity.ScreenEntity;

public class ScreenRenderer
extends EntityRenderer<ScreenEntity, ScreenRenderState> {
    private final ClientSlideshowManager slideshowManager = MultimediaClientMod.slideshowManager();
    private final Font font;

    public ScreenRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.font = context.getFont();
    }

    public void render(ScreenRenderState state, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        super.render((EntityRenderState)state, poseStack, bufferSource, packedLight);
        poseStack.pushPose();
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-state.yRot));
        poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(state.xRot));
        SlideshowGraphics graphics = SlideshowGraphics.forWorld(poseStack.last(), state.width, state.height, 0xF000F0, bufferSource, this.font);
        if (graphics != null) {
            graphics.fill(0, 0, graphics.width(), graphics.height(), -16777216);
            if (state.slideshowState != null) {
                state.slideshowState.draw(graphics);
            }
        }
        poseStack.popPose();
    }

    public ScreenRenderState createRenderState() {
        return new ScreenRenderState();
    }

    public void extractRenderState(ScreenEntity entity, ScreenRenderState state, float partialTick) {
        super.extractRenderState((Entity)entity, (EntityRenderState)state, partialTick);
        state.yRot = entity.getYRot(partialTick);
        state.xRot = entity.getXRot(partialTick);
        state.width = entity.getWidth();
        state.height = entity.getHeight();
        ScreenClientState screenState = this.slideshowManager.getScreenState(entity);
        state.slideshowState = screenState != null ? screenState.extractRenderState(partialTick) : null;
    }
}

