/*
 * Decompiled with CFR 0.152.
 */
package org.lovetropics.multimedia.mod.client.playback;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import javax.sound.sampled.AudioFormat;
import net.minecraft.util.Mth;
import org.lovetropics.multimedia.AudioFrame;
import org.lovetropics.multimedia.DecoderException;
import org.lwjgl.BufferUtils;

public class AudioSampler {
    private final AudioFormat inputFormat;
    @Nullable
    private ByteBuffer inputBuffer;

    public AudioSampler(AudioFormat inputFormat) {
        if (inputFormat.getSampleSizeInBits() != 16) {
            throw new IllegalArgumentException("Unsupported sample size: " + inputFormat.getSampleSizeInBits());
        }
        if (inputFormat.getEncoding() != AudioFormat.Encoding.PCM_SIGNED) {
            throw new IllegalArgumentException("Unsupported sample encoding: " + String.valueOf(inputFormat.getEncoding()));
        }
        this.inputFormat = inputFormat;
    }

    public ByteBuffer sample(AudioFrame inputFrame, int outputSamples) throws DecoderException {
        if (this.inputBuffer == null || this.inputBuffer.capacity() < inputFrame.bytes()) {
            this.inputBuffer = BufferUtils.createByteBuffer((int)inputFrame.bytes());
        }
        this.inputBuffer.clear();
        inputFrame.unpackSamples(this.inputBuffer);
        this.inputBuffer.flip();
        int inputSamples = inputFrame.samples();
        if (inputSamples == outputSamples) {
            return this.inputBuffer;
        }
        int channels = this.inputFormat.getChannels();
        ByteBuffer outputBuffer = BufferUtils.createByteBuffer((int)(outputSamples * channels * 2));
        for (int outputIndex = 0; outputIndex < outputSamples; ++outputIndex) {
            double scaledIndex = (double)outputIndex / (double)outputSamples * (double)inputSamples;
            int inputIndex = Mth.floor((double)scaledIndex);
            double alpha = scaledIndex - (double)inputIndex;
            int nextInputIndex = Math.min(inputIndex + 1, inputSamples - 1);
            for (int channelIndex = 0; channelIndex < channels; ++channelIndex) {
                short sample = this.inputBuffer.getShort((inputIndex * channels + channelIndex) * 2);
                short nextSample = this.inputBuffer.getShort((nextInputIndex * channels + channelIndex) * 2);
                outputBuffer.putShort((short)Math.round(Mth.lerp((double)alpha, (double)sample, (double)nextSample)));
            }
        }
        return outputBuffer.flip();
    }
}

