/*
 * Decompiled with CFR 0.152.
 */
package org.lovetropics.multimedia.mod.client.playback;

import com.mojang.blaze3d.audio.ListenerTransform;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public interface AudioWorldSource {
    public Vec3 resolveSourcePos(ListenerTransform var1);

    public float attenuationDistance();

    public record Rectangle(Vec3 origin, Quaternionfc rotation, float width, float height, float attenuationDistance) implements AudioWorldSource
    {
        @Override
        public Vec3 resolveSourcePos(ListenerTransform listenerTransform) {
            Vector3f relativeListenerPos = listenerTransform.position().subtract(this.origin).toVector3f();
            Vector3f localListenerPos = this.rotation.transformInverseUnit(relativeListenerPos);
            Vector3f localListenerDirection = this.rotation.transformInverseUnit(listenerTransform.forward().toVector3f());
            if ((double)Math.abs(localListenerDirection.z()) > 0.1) {
                localListenerDirection.mul(Math.abs(localListenerPos.z()) / Math.abs(localListenerDirection.z()));
            } else {
                localListenerDirection.set(0.0f);
            }
            this.rotation.transformUnit(Mth.clamp((float)(localListenerPos.x + localListenerDirection.x), (float)(-this.width / 2.0f), (float)(this.width / 2.0f)), Mth.clamp((float)(localListenerPos.z + localListenerDirection.y), (float)(-this.height / 2.0f), (float)(this.height / 2.0f)), 0.0f, localListenerPos);
            return new Vec3(localListenerPos).add(this.origin);
        }
    }

    public record Point(Vec3 origin, float attenuationDistance) implements AudioWorldSource
    {
        @Override
        public Vec3 resolveSourcePos(ListenerTransform listenerTransform) {
            return this.origin;
        }
    }
}

