/*
 * Decompiled with CFR 0.152.
 */
package org.lovetropics.multimedia.mod.client.playback;

import com.mojang.blaze3d.platform.Window;

public record FrameSize(int width, int height) {
    public FrameSize {
        width = Math.max(width, 1);
        height = Math.max(height, 1);
    }

    public static FrameSize from(Window window) {
        return new FrameSize(window.getWidth(), window.getHeight());
    }

    public FrameSize fitInto(FrameSize windowSize) {
        FrameSize result = this;
        if (result.width > windowSize.width) {
            result = result.resizeWidth(windowSize.width);
        }
        if (result.height > windowSize.height) {
            result = result.resizeHeight(windowSize.height);
        }
        return result;
    }

    public FrameSize resizeInto(FrameSize windowSize) {
        FrameSize resizedWidth = this.resizeWidth(windowSize.width);
        if (resizedWidth.height <= windowSize.height) {
            return resizedWidth;
        }
        return this.resizeHeight(windowSize.height);
    }

    public FrameSize resizeWidth(int newWidth) {
        return new FrameSize(newWidth, this.height * newWidth / this.width);
    }

    public FrameSize resizeHeight(int newHeight) {
        return new FrameSize(this.width * newHeight / this.height, newHeight);
    }

    public FrameSize scale(float scale) {
        return new FrameSize(Math.round((float)this.width * scale), Math.round((float)this.height * scale));
    }
}

